/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the <code>removePermissionResponse</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemovePermissionResponse extends CodeGuruProfilerResponse implements
        ToCopyableBuilder<RemovePermissionResponse.Builder, RemovePermissionResponse> {
    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(RemovePermissionResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(RemovePermissionResponse::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD,
            REVISION_ID_FIELD));

    private final String policy;

    private final String revisionId;

    private RemovePermissionResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The JSON-formatted resource-based policy on the profiling group after the specified permissions were removed.
     * </p>
     * 
     * @return The JSON-formatted resource-based policy on the profiling group after the specified permissions were
     *         removed.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * A universally unique identifier (UUID) for the revision of the resource-based policy after the specified
     * permissions were removed. The updated JSON-formatted policy is in the <code>policy</code> element of the
     * response.
     * </p>
     * 
     * @return A universally unique identifier (UUID) for the revision of the resource-based policy after the specified
     *         permissions were removed. The updated JSON-formatted policy is in the <code>policy</code> element of the
     *         response.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionResponse)) {
            return false;
        }
        RemovePermissionResponse other = (RemovePermissionResponse) obj;
        return Objects.equals(policy(), other.policy()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemovePermissionResponse").add("Policy", policy()).add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemovePermissionResponse, T> g) {
        return obj -> g.apply((RemovePermissionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RemovePermissionResponse> {
        /**
         * <p>
         * The JSON-formatted resource-based policy on the profiling group after the specified permissions were removed.
         * </p>
         * 
         * @param policy
         *        The JSON-formatted resource-based policy on the profiling group after the specified permissions were
         *        removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * A universally unique identifier (UUID) for the revision of the resource-based policy after the specified
         * permissions were removed. The updated JSON-formatted policy is in the <code>policy</code> element of the
         * response.
         * </p>
         * 
         * @param revisionId
         *        A universally unique identifier (UUID) for the revision of the resource-based policy after the
         *        specified permissions were removed. The updated JSON-formatted policy is in the <code>policy</code>
         *        element of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl extends CodeGuruProfilerResponse.BuilderImpl implements Builder {
        private String policy;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionResponse model) {
            super(model);
            policy(model.policy);
            revisionId(model.revisionId);
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public RemovePermissionResponse build() {
            return new RemovePermissionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
