/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the updateProfilingGroupResponse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProfilingGroupResponse extends CodeGuruProfilerResponse implements
        ToCopyableBuilder<UpdateProfilingGroupResponse.Builder, UpdateProfilingGroupResponse> {
    private static final SdkField<ProfilingGroupDescription> PROFILING_GROUP_FIELD = SdkField
            .<ProfilingGroupDescription> builder(MarshallingType.SDK_POJO)
            .memberName("profilingGroup")
            .getter(getter(UpdateProfilingGroupResponse::profilingGroup))
            .setter(setter(Builder::profilingGroup))
            .constructor(ProfilingGroupDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroup").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILING_GROUP_FIELD));

    private final ProfilingGroupDescription profilingGroup;

    private UpdateProfilingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.profilingGroup = builder.profilingGroup;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> that contains information about the returned updated profiling group.
     * </p>
     * 
     * @return A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     *         <code>ProfilingGroupDescription</code> </a> that contains information about the returned updated
     *         profiling group.
     */
    public final ProfilingGroupDescription profilingGroup() {
        return profilingGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfilingGroupResponse)) {
            return false;
        }
        UpdateProfilingGroupResponse other = (UpdateProfilingGroupResponse) obj;
        return Objects.equals(profilingGroup(), other.profilingGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProfilingGroupResponse").add("ProfilingGroup", profilingGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profilingGroup":
            return Optional.ofNullable(clazz.cast(profilingGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfilingGroupResponse, T> g) {
        return obj -> g.apply((UpdateProfilingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProfilingGroupResponse> {
        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> that contains information about the returned updated profiling
         * group.
         * </p>
         * 
         * @param profilingGroup
         *        A <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         *        <code>ProfilingGroupDescription</code> </a> that contains information about the returned updated
         *        profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroup(ProfilingGroupDescription profilingGroup);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> that contains information about the returned updated profiling
         * group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfilingGroupDescription.Builder}
         * avoiding the need to create one manually via {@link ProfilingGroupDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProfilingGroupDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #profilingGroup(ProfilingGroupDescription)}.
         * 
         * @param profilingGroup
         *        a consumer that will call methods on {@link ProfilingGroupDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profilingGroup(ProfilingGroupDescription)
         */
        default Builder profilingGroup(Consumer<ProfilingGroupDescription.Builder> profilingGroup) {
            return profilingGroup(ProfilingGroupDescription.builder().applyMutation(profilingGroup).build());
        }
    }

    static final class BuilderImpl extends CodeGuruProfilerResponse.BuilderImpl implements Builder {
        private ProfilingGroupDescription profilingGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfilingGroupResponse model) {
            super(model);
            profilingGroup(model.profilingGroup);
        }

        public final ProfilingGroupDescription.Builder getProfilingGroup() {
            return profilingGroup != null ? profilingGroup.toBuilder() : null;
        }

        public final void setProfilingGroup(ProfilingGroupDescription.BuilderImpl profilingGroup) {
            this.profilingGroup = profilingGroup != null ? profilingGroup.build() : null;
        }

        @Override
        public final Builder profilingGroup(ProfilingGroupDescription profilingGroup) {
            this.profilingGroup = profilingGroup;
            return this;
        }

        @Override
        public UpdateProfilingGroupResponse build() {
            return new UpdateProfilingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
