/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.StatusDetailFilters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOrganizationConfigRuleDetailedStatusRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, GetOrganizationConfigRuleDetailedStatusRequest> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationConfigRuleName").getter(GetOrganizationConfigRuleDetailedStatusRequest.getter(GetOrganizationConfigRuleDetailedStatusRequest::organizationConfigRuleName)).setter(GetOrganizationConfigRuleDetailedStatusRequest.setter(Builder::organizationConfigRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleName").build()}).build();
    private static final SdkField<StatusDetailFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(GetOrganizationConfigRuleDetailedStatusRequest.getter(GetOrganizationConfigRuleDetailedStatusRequest::filters)).setter(GetOrganizationConfigRuleDetailedStatusRequest.setter(Builder::filters)).constructor(StatusDetailFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(GetOrganizationConfigRuleDetailedStatusRequest.getter(GetOrganizationConfigRuleDetailedStatusRequest::limit)).setter(GetOrganizationConfigRuleDetailedStatusRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetOrganizationConfigRuleDetailedStatusRequest.getter(GetOrganizationConfigRuleDetailedStatusRequest::nextToken)).setter(GetOrganizationConfigRuleDetailedStatusRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFIG_RULE_NAME_FIELD, FILTERS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOrganizationConfigRuleDetailedStatusRequest.memberNameToFieldInitializer();
    private final String organizationConfigRuleName;
    private final StatusDetailFilters filters;
    private final Integer limit;
    private final String nextToken;

    private GetOrganizationConfigRuleDetailedStatusRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleName = builder.organizationConfigRuleName;
        this.filters = builder.filters;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String organizationConfigRuleName() {
        return this.organizationConfigRuleName;
    }

    public final StatusDetailFilters filters() {
        return this.filters;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfigRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationConfigRuleDetailedStatusRequest)) {
            return false;
        }
        GetOrganizationConfigRuleDetailedStatusRequest other = (GetOrganizationConfigRuleDetailedStatusRequest)((Object)obj);
        return Objects.equals(this.organizationConfigRuleName(), other.organizationConfigRuleName()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetOrganizationConfigRuleDetailedStatusRequest").add("OrganizationConfigRuleName", (Object)this.organizationConfigRuleName()).add("Filters", (Object)this.filters()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleName()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationConfigRuleName", ORGANIZATION_CONFIG_RULE_NAME_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationConfigRuleDetailedStatusRequest, T> g) {
        return obj -> g.apply((GetOrganizationConfigRuleDetailedStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String organizationConfigRuleName;
        private StatusDetailFilters filters;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationConfigRuleDetailedStatusRequest model) {
            super(model);
            this.organizationConfigRuleName(model.organizationConfigRuleName);
            this.filters(model.filters);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getOrganizationConfigRuleName() {
            return this.organizationConfigRuleName;
        }

        public final void setOrganizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
        }

        @Override
        public final Builder organizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
            return this;
        }

        public final StatusDetailFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(StatusDetailFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(StatusDetailFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOrganizationConfigRuleDetailedStatusRequest build() {
            return new GetOrganizationConfigRuleDetailedStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOrganizationConfigRuleDetailedStatusRequest> {
        public Builder organizationConfigRuleName(String var1);

        public Builder filters(StatusDetailFilters var1);

        default public Builder filters(Consumer<StatusDetailFilters.Builder> filters) {
            return this.filters((StatusDetailFilters)((StatusDetailFilters.Builder)StatusDetailFilters.builder().applyMutation(filters)).build());
        }

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

