/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the filter to apply when retrieving metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filters implements SdkPojo, Serializable, ToCopyableBuilder<Filters.Builder, Filters> {
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Queues")
            .getter(getter(Filters::queues))
            .setter(setter(Builder::queues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Channels")
            .getter(getter(Filters::channelsAsStrings))
            .setter(setter(Builder::channelsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUES_FIELD, CHANNELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> queues;

    private final List<String> channels;

    private Filters(BuilderImpl builder) {
        this.queues = builder.queues;
        this.channels = builder.channels;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueues() {
        return queues != null && !(queues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The queues to use to filter the metrics. You should specify at least one queue, and can specify up to 100 queues
     * per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when you include a
     * <code>Filter</code> in your request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueues} method.
     * </p>
     * 
     * @return The queues to use to filter the metrics. You should specify at least one queue, and can specify up to 100
     *         queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when you
     *         include a <code>Filter</code> in your request.
     */
    public final List<String> queues() {
        return queues;
    }

    /**
     * <p>
     * The channel to use to filter the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return The channel to use to filter the metrics.
     */
    public final List<Channel> channels() {
        return ChannelsCopier.copyStringToEnum(channels);
    }

    /**
     * For responses, this returns true if the service returned a value for the Channels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The channel to use to filter the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return The channel to use to filter the metrics.
     */
    public final List<String> channelsAsStrings() {
        return channels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasQueues() ? queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channelsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters) obj;
        return hasQueues() == other.hasQueues() && Objects.equals(queues(), other.queues())
                && hasChannels() == other.hasChannels() && Objects.equals(channelsAsStrings(), other.channelsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filters").add("Queues", hasQueues() ? queues() : null)
                .add("Channels", hasChannels() ? channelsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Queues":
            return Optional.ofNullable(clazz.cast(queues()));
        case "Channels":
            return Optional.ofNullable(clazz.cast(channelsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filters> {
        /**
         * <p>
         * The queues to use to filter the metrics. You should specify at least one queue, and can specify up to 100
         * queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when you
         * include a <code>Filter</code> in your request.
         * </p>
         * 
         * @param queues
         *        The queues to use to filter the metrics. You should specify at least one queue, and can specify up to
         *        100 queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when
         *        you include a <code>Filter</code> in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(Collection<String> queues);

        /**
         * <p>
         * The queues to use to filter the metrics. You should specify at least one queue, and can specify up to 100
         * queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when you
         * include a <code>Filter</code> in your request.
         * </p>
         * 
         * @param queues
         *        The queues to use to filter the metrics. You should specify at least one queue, and can specify up to
         *        100 queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when
         *        you include a <code>Filter</code> in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(String... queues);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(Collection<String> channels);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(String... channels);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<Channel> channels);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Channel... channels);
    }

    static final class BuilderImpl implements Builder {
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();

        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            queues(model.queues);
            channelsWithStrings(model.channels);
        }

        public final Collection<String> getQueues() {
            if (queues instanceof SdkAutoConstructList) {
                return null;
            }
            return queues;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String... queues) {
            queues(Arrays.asList(queues));
            return this;
        }

        public final Collection<String> getChannels() {
            if (channels instanceof SdkAutoConstructList) {
                return null;
            }
            return channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String... channels) {
            channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        @Override
        public Filters build() {
            return new Filters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
