/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A field that is invisible to an agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvisibleFieldInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InvisibleFieldInfo.Builder, InvisibleFieldInfo> {
    private static final SdkField<TaskTemplateFieldIdentifier> ID_FIELD = SdkField
            .<TaskTemplateFieldIdentifier> builder(MarshallingType.SDK_POJO).memberName("Id")
            .getter(getter(InvisibleFieldInfo::id)).setter(setter(Builder::id)).constructor(TaskTemplateFieldIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final TaskTemplateFieldIdentifier id;

    private InvisibleFieldInfo(BuilderImpl builder) {
        this.id = builder.id;
    }

    /**
     * <p>
     * Identifier of the invisible field.
     * </p>
     * 
     * @return Identifier of the invisible field.
     */
    public final TaskTemplateFieldIdentifier id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvisibleFieldInfo)) {
            return false;
        }
        InvisibleFieldInfo other = (InvisibleFieldInfo) obj;
        return Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvisibleFieldInfo").add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvisibleFieldInfo, T> g) {
        return obj -> g.apply((InvisibleFieldInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvisibleFieldInfo> {
        /**
         * <p>
         * Identifier of the invisible field.
         * </p>
         * 
         * @param id
         *        Identifier of the invisible field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(TaskTemplateFieldIdentifier id);

        /**
         * <p>
         * Identifier of the invisible field.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskTemplateFieldIdentifier.Builder}
         * avoiding the need to create one manually via {@link TaskTemplateFieldIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskTemplateFieldIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #id(TaskTemplateFieldIdentifier)}.
         * 
         * @param id
         *        a consumer that will call methods on {@link TaskTemplateFieldIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id(TaskTemplateFieldIdentifier)
         */
        default Builder id(Consumer<TaskTemplateFieldIdentifier.Builder> id) {
            return id(TaskTemplateFieldIdentifier.builder().applyMutation(id).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TaskTemplateFieldIdentifier id;

        private BuilderImpl() {
        }

        private BuilderImpl(InvisibleFieldInfo model) {
            id(model.id);
        }

        public final TaskTemplateFieldIdentifier.Builder getId() {
            return id != null ? id.toBuilder() : null;
        }

        public final void setId(TaskTemplateFieldIdentifier.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(TaskTemplateFieldIdentifier id) {
            this.id = id;
            return this;
        }

        @Override
        public InvisibleFieldInfo build() {
            return new InvisibleFieldInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
