/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ServiceManagedEBSVolumeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceVolumeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ServiceVolumeConfiguration.getter(ServiceVolumeConfiguration::name)).setter(ServiceVolumeConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ServiceManagedEBSVolumeConfiguration> MANAGED_EBS_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedEBSVolume").getter(ServiceVolumeConfiguration.getter(ServiceVolumeConfiguration::managedEBSVolume)).setter(ServiceVolumeConfiguration.setter(Builder::managedEBSVolume)).constructor(ServiceManagedEBSVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEBSVolume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MANAGED_EBS_VOLUME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceVolumeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ServiceManagedEBSVolumeConfiguration managedEBSVolume;

    private ServiceVolumeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.managedEBSVolume = builder.managedEBSVolume;
    }

    public final String name() {
        return this.name;
    }

    public final ServiceManagedEBSVolumeConfiguration managedEBSVolume() {
        return this.managedEBSVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedEBSVolume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceVolumeConfiguration)) {
            return false;
        }
        ServiceVolumeConfiguration other = (ServiceVolumeConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.managedEBSVolume(), other.managedEBSVolume());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceVolumeConfiguration").add("Name", (Object)this.name()).add("ManagedEBSVolume", (Object)this.managedEBSVolume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "managedEBSVolume": {
                return Optional.ofNullable(clazz.cast(this.managedEBSVolume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("managedEBSVolume", MANAGED_EBS_VOLUME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceVolumeConfiguration, T> g) {
        return obj -> g.apply((ServiceVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ServiceManagedEBSVolumeConfiguration managedEBSVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceVolumeConfiguration model) {
            this.name(model.name);
            this.managedEBSVolume(model.managedEBSVolume);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServiceManagedEBSVolumeConfiguration.Builder getManagedEBSVolume() {
            return this.managedEBSVolume != null ? this.managedEBSVolume.toBuilder() : null;
        }

        public final void setManagedEBSVolume(ServiceManagedEBSVolumeConfiguration.BuilderImpl managedEBSVolume) {
            this.managedEBSVolume = managedEBSVolume != null ? managedEBSVolume.build() : null;
        }

        @Override
        public final Builder managedEBSVolume(ServiceManagedEBSVolumeConfiguration managedEBSVolume) {
            this.managedEBSVolume = managedEBSVolume;
            return this;
        }

        public ServiceVolumeConfiguration build() {
            return new ServiceVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceVolumeConfiguration> {
        public Builder name(String var1);

        public Builder managedEBSVolume(ServiceManagedEBSVolumeConfiguration var1);

        default public Builder managedEBSVolume(Consumer<ServiceManagedEBSVolumeConfiguration.Builder> managedEBSVolume) {
            return this.managedEBSVolume((ServiceManagedEBSVolumeConfiguration)((ServiceManagedEBSVolumeConfiguration.Builder)ServiceManagedEBSVolumeConfiguration.builder().applyMutation(managedEBSVolume)).build());
        }
    }
}

