/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthenticationMode {
    API("API"),
    API_AND_CONFIG_MAP("API_AND_CONFIG_MAP"),
    CONFIG_MAP("CONFIG_MAP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthenticationMode> VALUE_MAP;
    private final String value;

    private AuthenticationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthenticationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthenticationMode> knownValues() {
        EnumSet<AuthenticationMode> knownValues = EnumSet.allOf(AuthenticationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthenticationMode.class, AuthenticationMode::toString);
    }
}

