/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorConfigProvider {
    EKS_ANYWHERE("EKS_ANYWHERE"),
    ANTHOS("ANTHOS"),
    GKE("GKE"),
    AKS("AKS"),
    OPENSHIFT("OPENSHIFT"),
    TANZU("TANZU"),
    RANCHER("RANCHER"),
    EC2("EC2"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorConfigProvider> VALUE_MAP;
    private final String value;

    private ConnectorConfigProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorConfigProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorConfigProvider> knownValues() {
        EnumSet<ConnectorConfigProvider> knownValues = EnumSet.allOf(ConnectorConfigProvider.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorConfigProvider.class, ConnectorConfigProvider::toString);
    }
}

