/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.InsightStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightResourceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightResourceDetail> {
    private static final SdkField<InsightStatus> INSIGHT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("insightStatus").getter(InsightResourceDetail.getter(InsightResourceDetail::insightStatus)).setter(InsightResourceDetail.setter(Builder::insightStatus)).constructor(InsightStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insightStatus").build()}).build();
    private static final SdkField<String> KUBERNETES_RESOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kubernetesResourceUri").getter(InsightResourceDetail.getter(InsightResourceDetail::kubernetesResourceUri)).setter(InsightResourceDetail.setter(Builder::kubernetesResourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesResourceUri").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(InsightResourceDetail.getter(InsightResourceDetail::arn)).setter(InsightResourceDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_STATUS_FIELD, KUBERNETES_RESOURCE_URI_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InsightResourceDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InsightStatus insightStatus;
    private final String kubernetesResourceUri;
    private final String arn;

    private InsightResourceDetail(BuilderImpl builder) {
        this.insightStatus = builder.insightStatus;
        this.kubernetesResourceUri = builder.kubernetesResourceUri;
        this.arn = builder.arn;
    }

    public final InsightStatus insightStatus() {
        return this.insightStatus;
    }

    public final String kubernetesResourceUri() {
        return this.kubernetesResourceUri;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.insightStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesResourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightResourceDetail)) {
            return false;
        }
        InsightResourceDetail other = (InsightResourceDetail)obj;
        return Objects.equals(this.insightStatus(), other.insightStatus()) && Objects.equals(this.kubernetesResourceUri(), other.kubernetesResourceUri()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"InsightResourceDetail").add("InsightStatus", (Object)this.insightStatus()).add("KubernetesResourceUri", (Object)this.kubernetesResourceUri()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "insightStatus": {
                return Optional.ofNullable(clazz.cast(this.insightStatus()));
            }
            case "kubernetesResourceUri": {
                return Optional.ofNullable(clazz.cast(this.kubernetesResourceUri()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("insightStatus", INSIGHT_STATUS_FIELD);
        map.put("kubernetesResourceUri", KUBERNETES_RESOURCE_URI_FIELD);
        map.put("arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightResourceDetail, T> g) {
        return obj -> g.apply((InsightResourceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InsightStatus insightStatus;
        private String kubernetesResourceUri;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightResourceDetail model) {
            this.insightStatus(model.insightStatus);
            this.kubernetesResourceUri(model.kubernetesResourceUri);
            this.arn(model.arn);
        }

        public final InsightStatus.Builder getInsightStatus() {
            return this.insightStatus != null ? this.insightStatus.toBuilder() : null;
        }

        public final void setInsightStatus(InsightStatus.BuilderImpl insightStatus) {
            this.insightStatus = insightStatus != null ? insightStatus.build() : null;
        }

        @Override
        public final Builder insightStatus(InsightStatus insightStatus) {
            this.insightStatus = insightStatus;
            return this;
        }

        public final String getKubernetesResourceUri() {
            return this.kubernetesResourceUri;
        }

        public final void setKubernetesResourceUri(String kubernetesResourceUri) {
            this.kubernetesResourceUri = kubernetesResourceUri;
        }

        @Override
        public final Builder kubernetesResourceUri(String kubernetesResourceUri) {
            this.kubernetesResourceUri = kubernetesResourceUri;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public InsightResourceDetail build() {
            return new InsightResourceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightResourceDetail> {
        public Builder insightStatus(InsightStatus var1);

        default public Builder insightStatus(Consumer<InsightStatus.Builder> insightStatus) {
            return this.insightStatus((InsightStatus)((InsightStatus.Builder)InsightStatus.builder().applyMutation(insightStatus)).build());
        }

        public Builder kubernetesResourceUri(String var1);

        public Builder arn(String var1);
    }
}

