/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ListAccessEntriesRequest;
import software.amazon.awssdk.services.eks.model.ListAccessEntriesResponse;

public class ListAccessEntriesPublisher
implements SdkPublisher<ListAccessEntriesResponse> {
    private final EksAsyncClient client;
    private final ListAccessEntriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessEntriesPublisher(EksAsyncClient client, ListAccessEntriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessEntriesPublisher(EksAsyncClient client, ListAccessEntriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessEntriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessEntriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> accessEntries() {
        Function<ListAccessEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessEntries() != null) {
                return response.accessEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessEntriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessEntriesResponseFetcher
    implements AsyncPageFetcher<ListAccessEntriesResponse> {
        private ListAccessEntriesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessEntriesResponse> nextPage(ListAccessEntriesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessEntriesPublisher.this.client.listAccessEntries(ListAccessEntriesPublisher.this.firstRequest);
            }
            return ListAccessEntriesPublisher.this.client.listAccessEntries((ListAccessEntriesRequest)((Object)ListAccessEntriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

