/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.InsightSummary;
import software.amazon.awssdk.services.eks.model.ListInsightsRequest;
import software.amazon.awssdk.services.eks.model.ListInsightsResponse;

public class ListInsightsIterable
implements SdkIterable<ListInsightsResponse> {
    private final EksClient client;
    private final ListInsightsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInsightsIterable(EksClient client, ListInsightsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInsightsResponseFetcher();
    }

    public Iterator<ListInsightsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InsightSummary> insights() {
        Function<ListInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.insights() != null) {
                return response.insights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInsightsResponseFetcher
    implements SyncPageFetcher<ListInsightsResponse> {
        private ListInsightsResponseFetcher() {
        }

        public boolean hasNextPage(ListInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInsightsResponse nextPage(ListInsightsResponse previousPage) {
            if (previousPage == null) {
                return ListInsightsIterable.this.client.listInsights(ListInsightsIterable.this.firstRequest);
            }
            return ListInsightsIterable.this.client.listInsights((ListInsightsRequest)((Object)ListInsightsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

