/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectionAuthorizationType {
    BASIC("BASIC"),
    OAUTH_CLIENT_CREDENTIALS("OAUTH_CLIENT_CREDENTIALS"),
    API_KEY("API_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionAuthorizationType> VALUE_MAP;
    private final String value;

    private ConnectionAuthorizationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionAuthorizationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionAuthorizationType> knownValues() {
        EnumSet<ConnectionAuthorizationType> knownValues = EnumSet.allOf(ConnectionAuthorizationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectionAuthorizationType.class, ConnectionAuthorizationType::toString);
    }
}

