/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResultEntry;
import software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResultEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveTargetsResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, RemoveTargetsResponse> {
    private static final SdkField<Integer> FAILED_ENTRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedEntryCount").getter(RemoveTargetsResponse.getter(RemoveTargetsResponse::failedEntryCount)).setter(RemoveTargetsResponse.setter(Builder::failedEntryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntryCount").build()}).build();
    private static final SdkField<List<RemoveTargetsResultEntry>> FAILED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedEntries").getter(RemoveTargetsResponse.getter(RemoveTargetsResponse::failedEntries)).setter(RemoveTargetsResponse.setter(Builder::failedEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemoveTargetsResultEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ENTRY_COUNT_FIELD, FAILED_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveTargetsResponse.memberNameToFieldInitializer();
    private final Integer failedEntryCount;
    private final List<RemoveTargetsResultEntry> failedEntries;

    private RemoveTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntryCount = builder.failedEntryCount;
        this.failedEntries = builder.failedEntries;
    }

    public final Integer failedEntryCount() {
        return this.failedEntryCount;
    }

    public final boolean hasFailedEntries() {
        return this.failedEntries != null && !(this.failedEntries instanceof SdkAutoConstructList);
    }

    public final List<RemoveTargetsResultEntry> failedEntries() {
        return this.failedEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failedEntryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedEntries() ? this.failedEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTargetsResponse)) {
            return false;
        }
        RemoveTargetsResponse other = (RemoveTargetsResponse)((Object)obj);
        return Objects.equals(this.failedEntryCount(), other.failedEntryCount()) && this.hasFailedEntries() == other.hasFailedEntries() && Objects.equals(this.failedEntries(), other.failedEntries());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveTargetsResponse").add("FailedEntryCount", (Object)this.failedEntryCount()).add("FailedEntries", this.hasFailedEntries() ? this.failedEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedEntryCount": {
                return Optional.ofNullable(clazz.cast(this.failedEntryCount()));
            }
            case "FailedEntries": {
                return Optional.ofNullable(clazz.cast(this.failedEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FailedEntryCount", FAILED_ENTRY_COUNT_FIELD);
        map.put("FailedEntries", FAILED_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveTargetsResponse, T> g) {
        return obj -> g.apply((RemoveTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private Integer failedEntryCount;
        private List<RemoveTargetsResultEntry> failedEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTargetsResponse model) {
            super(model);
            this.failedEntryCount(model.failedEntryCount);
            this.failedEntries(model.failedEntries);
        }

        public final Integer getFailedEntryCount() {
            return this.failedEntryCount;
        }

        public final void setFailedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
        }

        @Override
        public final Builder failedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
            return this;
        }

        public final List<RemoveTargetsResultEntry.Builder> getFailedEntries() {
            List<RemoveTargetsResultEntry.Builder> result = RemoveTargetsResultEntryListCopier.copyToBuilder(this.failedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedEntries(Collection<RemoveTargetsResultEntry.BuilderImpl> failedEntries) {
            this.failedEntries = RemoveTargetsResultEntryListCopier.copyFromBuilder(failedEntries);
        }

        @Override
        public final Builder failedEntries(Collection<RemoveTargetsResultEntry> failedEntries) {
            this.failedEntries = RemoveTargetsResultEntryListCopier.copy(failedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(RemoveTargetsResultEntry ... failedEntries) {
            this.failedEntries(Arrays.asList(failedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(Consumer<RemoveTargetsResultEntry.Builder> ... failedEntries) {
            this.failedEntries(Stream.of(failedEntries).map(c -> (RemoveTargetsResultEntry)((RemoveTargetsResultEntry.Builder)RemoveTargetsResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RemoveTargetsResponse build() {
            return new RemoveTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveTargetsResponse> {
        public Builder failedEntryCount(Integer var1);

        public Builder failedEntries(Collection<RemoveTargetsResultEntry> var1);

        public Builder failedEntries(RemoveTargetsResultEntry ... var1);

        public Builder failedEntries(Consumer<RemoveTargetsResultEntry.Builder> ... var1);
    }
}

