/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisStreamSourceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisStreamSourceDescription> {
    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KinesisStreamARN").getter(KinesisStreamSourceDescription.getter(KinesisStreamSourceDescription::kinesisStreamARN)).setter(KinesisStreamSourceDescription.setter(Builder::kinesisStreamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamARN").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(KinesisStreamSourceDescription.getter(KinesisStreamSourceDescription::roleARN)).setter(KinesisStreamSourceDescription.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<Instant> DELIVERY_START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeliveryStartTimestamp").getter(KinesisStreamSourceDescription.getter(KinesisStreamSourceDescription::deliveryStartTimestamp)).setter(KinesisStreamSourceDescription.setter(Builder::deliveryStartTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStartTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KINESIS_STREAM_ARN_FIELD, ROLE_ARN_FIELD, DELIVERY_START_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KinesisStreamSourceDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kinesisStreamARN;
    private final String roleARN;
    private final Instant deliveryStartTimestamp;

    private KinesisStreamSourceDescription(BuilderImpl builder) {
        this.kinesisStreamARN = builder.kinesisStreamARN;
        this.roleARN = builder.roleARN;
        this.deliveryStartTimestamp = builder.deliveryStartTimestamp;
    }

    public final String kinesisStreamARN() {
        return this.kinesisStreamARN;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final Instant deliveryStartTimestamp() {
        return this.deliveryStartTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStartTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamSourceDescription)) {
            return false;
        }
        KinesisStreamSourceDescription other = (KinesisStreamSourceDescription)obj;
        return Objects.equals(this.kinesisStreamARN(), other.kinesisStreamARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.deliveryStartTimestamp(), other.deliveryStartTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisStreamSourceDescription").add("KinesisStreamARN", (Object)this.kinesisStreamARN()).add("RoleARN", (Object)this.roleARN()).add("DeliveryStartTimestamp", (Object)this.deliveryStartTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KinesisStreamARN": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "DeliveryStartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.deliveryStartTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KinesisStreamARN", KINESIS_STREAM_ARN_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("DeliveryStartTimestamp", DELIVERY_START_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisStreamSourceDescription, T> g) {
        return obj -> g.apply((KinesisStreamSourceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kinesisStreamARN;
        private String roleARN;
        private Instant deliveryStartTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamSourceDescription model) {
            this.kinesisStreamARN(model.kinesisStreamARN);
            this.roleARN(model.roleARN);
            this.deliveryStartTimestamp(model.deliveryStartTimestamp);
        }

        public final String getKinesisStreamARN() {
            return this.kinesisStreamARN;
        }

        public final void setKinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
        }

        @Override
        public final Builder kinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final Instant getDeliveryStartTimestamp() {
            return this.deliveryStartTimestamp;
        }

        public final void setDeliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
        }

        @Override
        public final Builder deliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
            return this;
        }

        public KinesisStreamSourceDescription build() {
            return new KinesisStreamSourceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisStreamSourceDescription> {
        public Builder kinesisStreamARN(String var1);

        public Builder roleARN(String var1);

        public Builder deliveryStartTimestamp(Instant var1);
    }
}

