/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteOpenCypherQueryResponse extends NeptunedataResponse implements
        ToCopyableBuilder<ExecuteOpenCypherQueryResponse.Builder, ExecuteOpenCypherQueryResponse> {
    private static final SdkField<Document> RESULTS_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("results").getter(getter(ExecuteOpenCypherQueryResponse::results)).setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Document results;

    private ExecuteOpenCypherQueryResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
    }

    /**
     * <p>
     * The openCypherquery results.
     * </p>
     * 
     * @return The openCypherquery results.
     */
    public final Document results() {
        return results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(results());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteOpenCypherQueryResponse)) {
            return false;
        }
        ExecuteOpenCypherQueryResponse other = (ExecuteOpenCypherQueryResponse) obj;
        return Objects.equals(results(), other.results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteOpenCypherQueryResponse").add("Results", results()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("results", RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteOpenCypherQueryResponse, T> g) {
        return obj -> g.apply((ExecuteOpenCypherQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ExecuteOpenCypherQueryResponse> {
        /**
         * <p>
         * The openCypherquery results.
         * </p>
         * 
         * @param results
         *        The openCypherquery results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Document results);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private Document results;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteOpenCypherQueryResponse model) {
            super(model);
            results(model.results);
        }

        public final Document getResults() {
            return results;
        }

        public final void setResults(Document results) {
            this.results = results;
        }

        @Override
        public final Builder results(Document results) {
            this.results = results;
            return this;
        }

        @Override
        public ExecuteOpenCypherQueryResponse build() {
            return new ExecuteOpenCypherQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
