/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlModelTrainingJobResponse extends NeptunedataResponse implements
        ToCopyableBuilder<GetMlModelTrainingJobResponse.Builder, GetMlModelTrainingJobResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetMlModelTrainingJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetMlModelTrainingJobResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<MlResourceDefinition> PROCESSING_JOB_FIELD = SdkField
            .<MlResourceDefinition> builder(MarshallingType.SDK_POJO).memberName("processingJob")
            .getter(getter(GetMlModelTrainingJobResponse::processingJob)).setter(setter(Builder::processingJob))
            .constructor(MlResourceDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingJob").build()).build();

    private static final SdkField<MlResourceDefinition> HPO_JOB_FIELD = SdkField
            .<MlResourceDefinition> builder(MarshallingType.SDK_POJO).memberName("hpoJob")
            .getter(getter(GetMlModelTrainingJobResponse::hpoJob)).setter(setter(Builder::hpoJob))
            .constructor(MlResourceDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpoJob").build()).build();

    private static final SdkField<MlResourceDefinition> MODEL_TRANSFORM_JOB_FIELD = SdkField
            .<MlResourceDefinition> builder(MarshallingType.SDK_POJO).memberName("modelTransformJob")
            .getter(getter(GetMlModelTrainingJobResponse::modelTransformJob)).setter(setter(Builder::modelTransformJob))
            .constructor(MlResourceDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelTransformJob").build()).build();

    private static final SdkField<List<MlConfigDefinition>> ML_MODELS_FIELD = SdkField
            .<List<MlConfigDefinition>> builder(MarshallingType.LIST)
            .memberName("mlModels")
            .getter(getter(GetMlModelTrainingJobResponse::mlModels))
            .setter(setter(Builder::mlModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MlConfigDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(MlConfigDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ID_FIELD,
            PROCESSING_JOB_FIELD, HPO_JOB_FIELD, MODEL_TRANSFORM_JOB_FIELD, ML_MODELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String id;

    private final MlResourceDefinition processingJob;

    private final MlResourceDefinition hpoJob;

    private final MlResourceDefinition modelTransformJob;

    private final List<MlConfigDefinition> mlModels;

    private GetMlModelTrainingJobResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.id = builder.id;
        this.processingJob = builder.processingJob;
        this.hpoJob = builder.hpoJob;
        this.modelTransformJob = builder.modelTransformJob;
        this.mlModels = builder.mlModels;
    }

    /**
     * <p>
     * The status of the model training job.
     * </p>
     * 
     * @return The status of the model training job.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The unique identifier of this model-training job.
     * </p>
     * 
     * @return The unique identifier of this model-training job.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The data processing job.
     * </p>
     * 
     * @return The data processing job.
     */
    public final MlResourceDefinition processingJob() {
        return processingJob;
    }

    /**
     * <p>
     * The HPO job.
     * </p>
     * 
     * @return The HPO job.
     */
    public final MlResourceDefinition hpoJob() {
        return hpoJob;
    }

    /**
     * <p>
     * The model transform job.
     * </p>
     * 
     * @return The model transform job.
     */
    public final MlResourceDefinition modelTransformJob() {
        return modelTransformJob;
    }

    /**
     * For responses, this returns true if the service returned a value for the MlModels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMlModels() {
        return mlModels != null && !(mlModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the configurations of the ML models being used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMlModels} method.
     * </p>
     * 
     * @return A list of the configurations of the ML models being used.
     */
    public final List<MlConfigDefinition> mlModels() {
        return mlModels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(processingJob());
        hashCode = 31 * hashCode + Objects.hashCode(hpoJob());
        hashCode = 31 * hashCode + Objects.hashCode(modelTransformJob());
        hashCode = 31 * hashCode + Objects.hashCode(hasMlModels() ? mlModels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlModelTrainingJobResponse)) {
            return false;
        }
        GetMlModelTrainingJobResponse other = (GetMlModelTrainingJobResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(id(), other.id())
                && Objects.equals(processingJob(), other.processingJob()) && Objects.equals(hpoJob(), other.hpoJob())
                && Objects.equals(modelTransformJob(), other.modelTransformJob()) && hasMlModels() == other.hasMlModels()
                && Objects.equals(mlModels(), other.mlModels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMlModelTrainingJobResponse").add("Status", status()).add("Id", id())
                .add("ProcessingJob", processingJob()).add("HpoJob", hpoJob()).add("ModelTransformJob", modelTransformJob())
                .add("MlModels", hasMlModels() ? mlModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "processingJob":
            return Optional.ofNullable(clazz.cast(processingJob()));
        case "hpoJob":
            return Optional.ofNullable(clazz.cast(hpoJob()));
        case "modelTransformJob":
            return Optional.ofNullable(clazz.cast(modelTransformJob()));
        case "mlModels":
            return Optional.ofNullable(clazz.cast(mlModels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("id", ID_FIELD);
        map.put("processingJob", PROCESSING_JOB_FIELD);
        map.put("hpoJob", HPO_JOB_FIELD);
        map.put("modelTransformJob", MODEL_TRANSFORM_JOB_FIELD);
        map.put("mlModels", ML_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMlModelTrainingJobResponse, T> g) {
        return obj -> g.apply((GetMlModelTrainingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMlModelTrainingJobResponse> {
        /**
         * <p>
         * The status of the model training job.
         * </p>
         * 
         * @param status
         *        The status of the model training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The unique identifier of this model-training job.
         * </p>
         * 
         * @param id
         *        The unique identifier of this model-training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The data processing job.
         * </p>
         * 
         * @param processingJob
         *        The data processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJob(MlResourceDefinition processingJob);

        /**
         * <p>
         * The data processing job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MlResourceDefinition.Builder} avoiding
         * the need to create one manually via {@link MlResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MlResourceDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #processingJob(MlResourceDefinition)}.
         * 
         * @param processingJob
         *        a consumer that will call methods on {@link MlResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingJob(MlResourceDefinition)
         */
        default Builder processingJob(Consumer<MlResourceDefinition.Builder> processingJob) {
            return processingJob(MlResourceDefinition.builder().applyMutation(processingJob).build());
        }

        /**
         * <p>
         * The HPO job.
         * </p>
         * 
         * @param hpoJob
         *        The HPO job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hpoJob(MlResourceDefinition hpoJob);

        /**
         * <p>
         * The HPO job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MlResourceDefinition.Builder} avoiding
         * the need to create one manually via {@link MlResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MlResourceDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #hpoJob(MlResourceDefinition)}.
         * 
         * @param hpoJob
         *        a consumer that will call methods on {@link MlResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hpoJob(MlResourceDefinition)
         */
        default Builder hpoJob(Consumer<MlResourceDefinition.Builder> hpoJob) {
            return hpoJob(MlResourceDefinition.builder().applyMutation(hpoJob).build());
        }

        /**
         * <p>
         * The model transform job.
         * </p>
         * 
         * @param modelTransformJob
         *        The model transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelTransformJob(MlResourceDefinition modelTransformJob);

        /**
         * <p>
         * The model transform job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MlResourceDefinition.Builder} avoiding
         * the need to create one manually via {@link MlResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MlResourceDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #modelTransformJob(MlResourceDefinition)}.
         * 
         * @param modelTransformJob
         *        a consumer that will call methods on {@link MlResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelTransformJob(MlResourceDefinition)
         */
        default Builder modelTransformJob(Consumer<MlResourceDefinition.Builder> modelTransformJob) {
            return modelTransformJob(MlResourceDefinition.builder().applyMutation(modelTransformJob).build());
        }

        /**
         * <p>
         * A list of the configurations of the ML models being used.
         * </p>
         * 
         * @param mlModels
         *        A list of the configurations of the ML models being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModels(Collection<MlConfigDefinition> mlModels);

        /**
         * <p>
         * A list of the configurations of the ML models being used.
         * </p>
         * 
         * @param mlModels
         *        A list of the configurations of the ML models being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModels(MlConfigDefinition... mlModels);

        /**
         * <p>
         * A list of the configurations of the ML models being used.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #mlModels(List<MlConfigDefinition>)}.
         * 
         * @param mlModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mlModels(java.util.Collection<MlConfigDefinition>)
         */
        Builder mlModels(Consumer<MlConfigDefinition.Builder>... mlModels);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String status;

        private String id;

        private MlResourceDefinition processingJob;

        private MlResourceDefinition hpoJob;

        private MlResourceDefinition modelTransformJob;

        private List<MlConfigDefinition> mlModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlModelTrainingJobResponse model) {
            super(model);
            status(model.status);
            id(model.id);
            processingJob(model.processingJob);
            hpoJob(model.hpoJob);
            modelTransformJob(model.modelTransformJob);
            mlModels(model.mlModels);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MlResourceDefinition.Builder getProcessingJob() {
            return processingJob != null ? processingJob.toBuilder() : null;
        }

        public final void setProcessingJob(MlResourceDefinition.BuilderImpl processingJob) {
            this.processingJob = processingJob != null ? processingJob.build() : null;
        }

        @Override
        public final Builder processingJob(MlResourceDefinition processingJob) {
            this.processingJob = processingJob;
            return this;
        }

        public final MlResourceDefinition.Builder getHpoJob() {
            return hpoJob != null ? hpoJob.toBuilder() : null;
        }

        public final void setHpoJob(MlResourceDefinition.BuilderImpl hpoJob) {
            this.hpoJob = hpoJob != null ? hpoJob.build() : null;
        }

        @Override
        public final Builder hpoJob(MlResourceDefinition hpoJob) {
            this.hpoJob = hpoJob;
            return this;
        }

        public final MlResourceDefinition.Builder getModelTransformJob() {
            return modelTransformJob != null ? modelTransformJob.toBuilder() : null;
        }

        public final void setModelTransformJob(MlResourceDefinition.BuilderImpl modelTransformJob) {
            this.modelTransformJob = modelTransformJob != null ? modelTransformJob.build() : null;
        }

        @Override
        public final Builder modelTransformJob(MlResourceDefinition modelTransformJob) {
            this.modelTransformJob = modelTransformJob;
            return this;
        }

        public final List<MlConfigDefinition.Builder> getMlModels() {
            List<MlConfigDefinition.Builder> result = MlModelsCopier.copyToBuilder(this.mlModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMlModels(Collection<MlConfigDefinition.BuilderImpl> mlModels) {
            this.mlModels = MlModelsCopier.copyFromBuilder(mlModels);
        }

        @Override
        public final Builder mlModels(Collection<MlConfigDefinition> mlModels) {
            this.mlModels = MlModelsCopier.copy(mlModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mlModels(MlConfigDefinition... mlModels) {
            mlModels(Arrays.asList(mlModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mlModels(Consumer<MlConfigDefinition.Builder>... mlModels) {
            mlModels(Stream.of(mlModels).map(c -> MlConfigDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMlModelTrainingJobResponse build() {
            return new GetMlModelTrainingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
