/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains status components of a Gremlin query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GremlinQueryStatusAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<GremlinQueryStatusAttributes.Builder, GremlinQueryStatusAttributes> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(GremlinQueryStatusAttributes::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Integer> CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("code")
            .getter(getter(GremlinQueryStatusAttributes::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<Document> ATTRIBUTES_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("attributes").getter(getter(GremlinQueryStatusAttributes::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, CODE_FIELD,
            ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final Integer code;

    private final Document attributes;

    private GremlinQueryStatusAttributes(BuilderImpl builder) {
        this.message = builder.message;
        this.code = builder.code;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The status message.
     * </p>
     * 
     * @return The status message.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The HTTP response code returned fro the Gremlin query request..
     * </p>
     * 
     * @return The HTTP response code returned fro the Gremlin query request..
     */
    public final Integer code() {
        return code;
    }

    /**
     * <p>
     * Attributes of the Gremlin query status.
     * </p>
     * 
     * @return Attributes of the Gremlin query status.
     */
    public final Document attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GremlinQueryStatusAttributes)) {
            return false;
        }
        GremlinQueryStatusAttributes other = (GremlinQueryStatusAttributes) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(code(), other.code())
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GremlinQueryStatusAttributes").add("Message", message()).add("Code", code())
                .add("Attributes", attributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("message", MESSAGE_FIELD);
        map.put("code", CODE_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GremlinQueryStatusAttributes, T> g) {
        return obj -> g.apply((GremlinQueryStatusAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GremlinQueryStatusAttributes> {
        /**
         * <p>
         * The status message.
         * </p>
         * 
         * @param message
         *        The status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The HTTP response code returned fro the Gremlin query request..
         * </p>
         * 
         * @param code
         *        The HTTP response code returned fro the Gremlin query request..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        /**
         * <p>
         * Attributes of the Gremlin query status.
         * </p>
         * 
         * @param attributes
         *        Attributes of the Gremlin query status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Document attributes);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private Integer code;

        private Document attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GremlinQueryStatusAttributes model) {
            message(model.message);
            code(model.code);
            attributes(model.attributes);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Integer getCode() {
            return code;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final Document getAttributes() {
            return attributes;
        }

        public final void setAttributes(Document attributes) {
            this.attributes = attributes;
        }

        @Override
        public final Builder attributes(Document attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public GremlinQueryStatusAttributes build() {
            return new GremlinQueryStatusAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
