/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOpenCypherQueriesResponse extends NeptunedataResponse implements
        ToCopyableBuilder<ListOpenCypherQueriesResponse.Builder, ListOpenCypherQueriesResponse> {
    private static final SdkField<Integer> ACCEPTED_QUERY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("acceptedQueryCount").getter(getter(ListOpenCypherQueriesResponse::acceptedQueryCount))
            .setter(setter(Builder::acceptedQueryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedQueryCount").build())
            .build();

    private static final SdkField<Integer> RUNNING_QUERY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("runningQueryCount").getter(getter(ListOpenCypherQueriesResponse::runningQueryCount))
            .setter(setter(Builder::runningQueryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningQueryCount").build()).build();

    private static final SdkField<List<GremlinQueryStatus>> QUERIES_FIELD = SdkField
            .<List<GremlinQueryStatus>> builder(MarshallingType.LIST)
            .memberName("queries")
            .getter(getter(ListOpenCypherQueriesResponse::queries))
            .setter(setter(Builder::queries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GremlinQueryStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(GremlinQueryStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTED_QUERY_COUNT_FIELD,
            RUNNING_QUERY_COUNT_FIELD, QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer acceptedQueryCount;

    private final Integer runningQueryCount;

    private final List<GremlinQueryStatus> queries;

    private ListOpenCypherQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.acceptedQueryCount = builder.acceptedQueryCount;
        this.runningQueryCount = builder.runningQueryCount;
        this.queries = builder.queries;
    }

    /**
     * <p>
     * The number of queries that have been accepted but not yet completed, including queries in the queue.
     * </p>
     * 
     * @return The number of queries that have been accepted but not yet completed, including queries in the queue.
     */
    public final Integer acceptedQueryCount() {
        return acceptedQueryCount;
    }

    /**
     * <p>
     * The number of currently running openCypher queries.
     * </p>
     * 
     * @return The number of currently running openCypher queries.
     */
    public final Integer runningQueryCount() {
        return runningQueryCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueries() {
        return queries != null && !(queries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of current openCypher queries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueries} method.
     * </p>
     * 
     * @return A list of current openCypher queries.
     */
    public final List<GremlinQueryStatus> queries() {
        return queries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptedQueryCount());
        hashCode = 31 * hashCode + Objects.hashCode(runningQueryCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueries() ? queries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenCypherQueriesResponse)) {
            return false;
        }
        ListOpenCypherQueriesResponse other = (ListOpenCypherQueriesResponse) obj;
        return Objects.equals(acceptedQueryCount(), other.acceptedQueryCount())
                && Objects.equals(runningQueryCount(), other.runningQueryCount()) && hasQueries() == other.hasQueries()
                && Objects.equals(queries(), other.queries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOpenCypherQueriesResponse").add("AcceptedQueryCount", acceptedQueryCount())
                .add("RunningQueryCount", runningQueryCount()).add("Queries", hasQueries() ? queries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceptedQueryCount":
            return Optional.ofNullable(clazz.cast(acceptedQueryCount()));
        case "runningQueryCount":
            return Optional.ofNullable(clazz.cast(runningQueryCount()));
        case "queries":
            return Optional.ofNullable(clazz.cast(queries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("acceptedQueryCount", ACCEPTED_QUERY_COUNT_FIELD);
        map.put("runningQueryCount", RUNNING_QUERY_COUNT_FIELD);
        map.put("queries", QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOpenCypherQueriesResponse, T> g) {
        return obj -> g.apply((ListOpenCypherQueriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOpenCypherQueriesResponse> {
        /**
         * <p>
         * The number of queries that have been accepted but not yet completed, including queries in the queue.
         * </p>
         * 
         * @param acceptedQueryCount
         *        The number of queries that have been accepted but not yet completed, including queries in the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedQueryCount(Integer acceptedQueryCount);

        /**
         * <p>
         * The number of currently running openCypher queries.
         * </p>
         * 
         * @param runningQueryCount
         *        The number of currently running openCypher queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningQueryCount(Integer runningQueryCount);

        /**
         * <p>
         * A list of current openCypher queries.
         * </p>
         * 
         * @param queries
         *        A list of current openCypher queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(Collection<GremlinQueryStatus> queries);

        /**
         * <p>
         * A list of current openCypher queries.
         * </p>
         * 
         * @param queries
         *        A list of current openCypher queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(GremlinQueryStatus... queries);

        /**
         * <p>
         * A list of current openCypher queries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptunedata.model.GremlinQueryStatus.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.neptunedata.model.GremlinQueryStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptunedata.model.GremlinQueryStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #queries(List<GremlinQueryStatus>)}.
         * 
         * @param queries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptunedata.model.GremlinQueryStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queries(java.util.Collection<GremlinQueryStatus>)
         */
        Builder queries(Consumer<GremlinQueryStatus.Builder>... queries);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private Integer acceptedQueryCount;

        private Integer runningQueryCount;

        private List<GremlinQueryStatus> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpenCypherQueriesResponse model) {
            super(model);
            acceptedQueryCount(model.acceptedQueryCount);
            runningQueryCount(model.runningQueryCount);
            queries(model.queries);
        }

        public final Integer getAcceptedQueryCount() {
            return acceptedQueryCount;
        }

        public final void setAcceptedQueryCount(Integer acceptedQueryCount) {
            this.acceptedQueryCount = acceptedQueryCount;
        }

        @Override
        public final Builder acceptedQueryCount(Integer acceptedQueryCount) {
            this.acceptedQueryCount = acceptedQueryCount;
            return this;
        }

        public final Integer getRunningQueryCount() {
            return runningQueryCount;
        }

        public final void setRunningQueryCount(Integer runningQueryCount) {
            this.runningQueryCount = runningQueryCount;
        }

        @Override
        public final Builder runningQueryCount(Integer runningQueryCount) {
            this.runningQueryCount = runningQueryCount;
            return this;
        }

        public final List<GremlinQueryStatus.Builder> getQueries() {
            List<GremlinQueryStatus.Builder> result = OpenCypherQueriesCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<GremlinQueryStatus.BuilderImpl> queries) {
            this.queries = OpenCypherQueriesCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<GremlinQueryStatus> queries) {
            this.queries = OpenCypherQueriesCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(GremlinQueryStatus... queries) {
            queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<GremlinQueryStatus.Builder>... queries) {
            queries(Stream.of(queries).map(c -> GremlinQueryStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOpenCypherQueriesResponse build() {
            return new ListOpenCypherQueriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
