/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartLoaderJobRequest extends NeptunedataRequest implements
        ToCopyableBuilder<StartLoaderJobRequest.Builder, StartLoaderJobRequest> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(StartLoaderJobRequest::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(StartLoaderJobRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> S3_BUCKET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketRegion").getter(getter(StartLoaderJobRequest::s3BucketRegionAsString))
            .setter(setter(Builder::s3BucketRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRoleArn").getter(getter(StartLoaderJobRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(StartLoaderJobRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<Boolean> FAIL_ON_ERROR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("failOnError").getter(getter(StartLoaderJobRequest::failOnError)).setter(setter(Builder::failOnError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failOnError").build()).build();

    private static final SdkField<String> PARALLELISM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parallelism").getter(getter(StartLoaderJobRequest::parallelismAsString))
            .setter(setter(Builder::parallelism))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelism").build()).build();

    private static final SdkField<Map<String, String>> PARSER_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parserConfiguration")
            .getter(getter(StartLoaderJobRequest::parserConfiguration))
            .setter(setter(Builder::parserConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parserConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> UPDATE_SINGLE_CARDINALITY_PROPERTIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("updateSingleCardinalityProperties")
            .getter(getter(StartLoaderJobRequest::updateSingleCardinalityProperties))
            .setter(setter(Builder::updateSingleCardinalityProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateSingleCardinalityProperties")
                    .build()).build();

    private static final SdkField<Boolean> QUEUE_REQUEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("queueRequest").getter(getter(StartLoaderJobRequest::queueRequest)).setter(setter(Builder::queueRequest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueRequest").build()).build();

    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dependencies")
            .getter(getter(StartLoaderJobRequest::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> USER_PROVIDED_EDGE_IDS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("userProvidedEdgeIds").getter(getter(StartLoaderJobRequest::userProvidedEdgeIds))
            .setter(setter(Builder::userProvidedEdgeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProvidedEdgeIds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, FORMAT_FIELD,
            S3_BUCKET_REGION_FIELD, IAM_ROLE_ARN_FIELD, MODE_FIELD, FAIL_ON_ERROR_FIELD, PARALLELISM_FIELD,
            PARSER_CONFIGURATION_FIELD, UPDATE_SINGLE_CARDINALITY_PROPERTIES_FIELD, QUEUE_REQUEST_FIELD, DEPENDENCIES_FIELD,
            USER_PROVIDED_EDGE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String source;

    private final String format;

    private final String s3BucketRegion;

    private final String iamRoleArn;

    private final String mode;

    private final Boolean failOnError;

    private final String parallelism;

    private final Map<String, String> parserConfiguration;

    private final Boolean updateSingleCardinalityProperties;

    private final Boolean queueRequest;

    private final List<String> dependencies;

    private final Boolean userProvidedEdgeIds;

    private StartLoaderJobRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.format = builder.format;
        this.s3BucketRegion = builder.s3BucketRegion;
        this.iamRoleArn = builder.iamRoleArn;
        this.mode = builder.mode;
        this.failOnError = builder.failOnError;
        this.parallelism = builder.parallelism;
        this.parserConfiguration = builder.parserConfiguration;
        this.updateSingleCardinalityProperties = builder.updateSingleCardinalityProperties;
        this.queueRequest = builder.queueRequest;
        this.dependencies = builder.dependencies;
        this.userProvidedEdgeIds = builder.userProvidedEdgeIds;
    }

    /**
     * <p>
     * The <code>source</code> parameter accepts an S3 URI that identifies a single file, multiple files, a folder, or
     * multiple folders. Neptune loads every data file in any folder that is specified.
     * </p>
     * <p>
     * The URI can be in any of the following formats.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>s3://(bucket_name)/(object-key-name)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https://s3.amazonaws.com/(bucket_name)/(object-key-name)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https://s3.us-east-1.amazonaws.com/(bucket_name)/(object-key-name)</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The <code>object-key-name</code> element of the URI is equivalent to the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html#API_ListObjects_RequestParameters"
     * >prefix</a> parameter in an S3 <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a> API call. It
     * identifies all the objects in the specified S3 bucket whose names begin with that prefix. That can be a single
     * file or folder, or multiple files and/or folders.
     * </p>
     * <p>
     * The specified folder or folders can contain multiple vertex files and multiple edge files.
     * </p>
     * 
     * @return The <code>source</code> parameter accepts an S3 URI that identifies a single file, multiple files, a
     *         folder, or multiple folders. Neptune loads every data file in any folder that is specified.</p>
     *         <p>
     *         The URI can be in any of the following formats.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>s3://(bucket_name)/(object-key-name)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https://s3.amazonaws.com/(bucket_name)/(object-key-name)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https://s3.us-east-1.amazonaws.com/(bucket_name)/(object-key-name)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The <code>object-key-name</code> element of the URI is equivalent to the <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html#API_ListObjects_RequestParameters"
     *         >prefix</a> parameter in an S3 <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a> API call. It
     *         identifies all the objects in the specified S3 bucket whose names begin with that prefix. That can be a
     *         single file or folder, or multiple files and/or folders.
     *         </p>
     *         <p>
     *         The specified folder or folders can contain multiple vertex files and multiple edge files.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The format of the data. For more information about data formats for the Neptune <code>Loader</code> command, see
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html">Load Data
     * Formats</a>.
     * </p>
     * <p class="title">
     * <b>Allowed values</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>csv</code> </b> for the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin CSV
     * data format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>opencypher</code> </b> for the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher
     * CSV data format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>ntriples</code> </b> for the <a href="https://www.w3.org/TR/n-triples/">N-Triples RDF data format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>nquads</code> </b> for the <a href="https://www.w3.org/TR/n-quads/">N-Quads RDF data format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>rdfxml</code> </b> for the <a href="https://www.w3.org/TR/rdf-syntax-grammar/">RDF\XML RDF data
     * format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>turtle</code> </b> for the <a href="https://www.w3.org/TR/turtle/">Turtle RDF data format</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the data. For more information about data formats for the Neptune <code>Loader</code>
     *         command, see <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html">Load Data
     *         Formats</a>.</p>
     *         <p class="title">
     *         <b>Allowed values</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>csv</code> </b> for the <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html"
     *         >Gremlin CSV data format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>opencypher</code> </b> for the <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
     *         >openCypher CSV data format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>ntriples</code> </b> for the <a href="https://www.w3.org/TR/n-triples/">N-Triples RDF data
     *         format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>nquads</code> </b> for the <a href="https://www.w3.org/TR/n-quads/">N-Quads RDF data
     *         format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>rdfxml</code> </b> for the <a href="https://www.w3.org/TR/rdf-syntax-grammar/">RDF\XML RDF data
     *         format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>turtle</code> </b> for the <a href="https://www.w3.org/TR/turtle/">Turtle RDF data format</a>.
     *         </p>
     *         </li>
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * The format of the data. For more information about data formats for the Neptune <code>Loader</code> command, see
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html">Load Data
     * Formats</a>.
     * </p>
     * <p class="title">
     * <b>Allowed values</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>csv</code> </b> for the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin CSV
     * data format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>opencypher</code> </b> for the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher
     * CSV data format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>ntriples</code> </b> for the <a href="https://www.w3.org/TR/n-triples/">N-Triples RDF data format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>nquads</code> </b> for the <a href="https://www.w3.org/TR/n-quads/">N-Quads RDF data format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>rdfxml</code> </b> for the <a href="https://www.w3.org/TR/rdf-syntax-grammar/">RDF\XML RDF data
     * format</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>turtle</code> </b> for the <a href="https://www.w3.org/TR/turtle/">Turtle RDF data format</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the data. For more information about data formats for the Neptune <code>Loader</code>
     *         command, see <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html">Load Data
     *         Formats</a>.</p>
     *         <p class="title">
     *         <b>Allowed values</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>csv</code> </b> for the <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html"
     *         >Gremlin CSV data format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>opencypher</code> </b> for the <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
     *         >openCypher CSV data format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>ntriples</code> </b> for the <a href="https://www.w3.org/TR/n-triples/">N-Triples RDF data
     *         format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>nquads</code> </b> for the <a href="https://www.w3.org/TR/n-quads/">N-Quads RDF data
     *         format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>rdfxml</code> </b> for the <a href="https://www.w3.org/TR/rdf-syntax-grammar/">RDF\XML RDF data
     *         format</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>turtle</code> </b> for the <a href="https://www.w3.org/TR/turtle/">Turtle RDF data format</a>.
     *         </p>
     *         </li>
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The Amazon region of the S3 bucket. This must match the Amazon Region of the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BucketRegion}
     * will return {@link S3BucketRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BucketRegionAsString}.
     * </p>
     * 
     * @return The Amazon region of the S3 bucket. This must match the Amazon Region of the DB cluster.
     * @see S3BucketRegion
     */
    public final S3BucketRegion s3BucketRegion() {
        return S3BucketRegion.fromValue(s3BucketRegion);
    }

    /**
     * <p>
     * The Amazon region of the S3 bucket. This must match the Amazon Region of the DB cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BucketRegion}
     * will return {@link S3BucketRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BucketRegionAsString}.
     * </p>
     * 
     * @return The Amazon region of the S3 bucket. This must match the Amazon Region of the DB cluster.
     * @see S3BucketRegion
     */
    public final String s3BucketRegionAsString() {
        return s3BucketRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for an IAM role to be assumed by the Neptune DB instance for access to the S3
     * bucket. The IAM role ARN provided here should be attached to the DB cluster (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-IAM-add-role-cluster.html">Adding
     * the IAM Role to an Amazon Neptune Cluster</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for an IAM role to be assumed by the Neptune DB instance for access to the
     *         S3 bucket. The IAM role ARN provided here should be attached to the DB cluster (see <a href=
     *         "https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-IAM-add-role-cluster.html"
     *         >Adding the IAM Role to an Amazon Neptune Cluster</a>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The load job mode.
     * </p>
     * <p>
     * <i>Allowed values</i>: <code>RESUME</code>, <code>NEW</code>, <code>AUTO</code>.
     * </p>
     * <p>
     * <i>Default value</i>: <code>AUTO</code>.
     * </p>
     * <p class="title">
     * <b/>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RESUME</code>   –   In RESUME mode, the loader looks for a previous load from this source, and if it finds
     * one, resumes that load job. If no previous load job is found, the loader stops.
     * </p>
     * <p>
     * The loader avoids reloading files that were successfully loaded in a previous job. It only tries to process
     * failed files. If you dropped previously loaded data from your Neptune cluster, that data is not reloaded in this
     * mode. If a previous load job loaded all files from the same source successfully, nothing is reloaded, and the
     * loader returns success.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW</code>   –   In NEW mode, the creates a new load request regardless of any previous loads. You can use
     * this mode to reload all the data from a source after dropping previously loaded data from your Neptune cluster,
     * or to load new data available at the same source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTO</code>   –   In AUTO mode, the loader looks for a previous load job from the same source, and if it
     * finds one, resumes that job, just as in <code>RESUME</code> mode.
     * </p>
     * <p>
     * If the loader doesn't find a previous load job from the same source, it loads all data from the source, just as
     * in <code>NEW</code> mode.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The load job mode.</p>
     *         <p>
     *         <i>Allowed values</i>: <code>RESUME</code>, <code>NEW</code>, <code>AUTO</code>.
     *         </p>
     *         <p>
     *         <i>Default value</i>: <code>AUTO</code>.
     *         </p>
     *         <p class="title">
     *         <b/>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RESUME</code>   –   In RESUME mode, the loader looks for a previous load from this source, and if
     *         it finds one, resumes that load job. If no previous load job is found, the loader stops.
     *         </p>
     *         <p>
     *         The loader avoids reloading files that were successfully loaded in a previous job. It only tries to
     *         process failed files. If you dropped previously loaded data from your Neptune cluster, that data is not
     *         reloaded in this mode. If a previous load job loaded all files from the same source successfully, nothing
     *         is reloaded, and the loader returns success.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW</code>   –   In NEW mode, the creates a new load request regardless of any previous loads. You
     *         can use this mode to reload all the data from a source after dropping previously loaded data from your
     *         Neptune cluster, or to load new data available at the same source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTO</code>   –   In AUTO mode, the loader looks for a previous load job from the same source, and
     *         if it finds one, resumes that job, just as in <code>RESUME</code> mode.
     *         </p>
     *         <p>
     *         If the loader doesn't find a previous load job from the same source, it loads all data from the source,
     *         just as in <code>NEW</code> mode.
     *         </p>
     *         </li>
     * @see Mode
     */
    public final Mode mode() {
        return Mode.fromValue(mode);
    }

    /**
     * <p>
     * The load job mode.
     * </p>
     * <p>
     * <i>Allowed values</i>: <code>RESUME</code>, <code>NEW</code>, <code>AUTO</code>.
     * </p>
     * <p>
     * <i>Default value</i>: <code>AUTO</code>.
     * </p>
     * <p class="title">
     * <b/>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RESUME</code>   –   In RESUME mode, the loader looks for a previous load from this source, and if it finds
     * one, resumes that load job. If no previous load job is found, the loader stops.
     * </p>
     * <p>
     * The loader avoids reloading files that were successfully loaded in a previous job. It only tries to process
     * failed files. If you dropped previously loaded data from your Neptune cluster, that data is not reloaded in this
     * mode. If a previous load job loaded all files from the same source successfully, nothing is reloaded, and the
     * loader returns success.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW</code>   –   In NEW mode, the creates a new load request regardless of any previous loads. You can use
     * this mode to reload all the data from a source after dropping previously loaded data from your Neptune cluster,
     * or to load new data available at the same source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTO</code>   –   In AUTO mode, the loader looks for a previous load job from the same source, and if it
     * finds one, resumes that job, just as in <code>RESUME</code> mode.
     * </p>
     * <p>
     * If the loader doesn't find a previous load job from the same source, it loads all data from the source, just as
     * in <code>NEW</code> mode.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The load job mode.</p>
     *         <p>
     *         <i>Allowed values</i>: <code>RESUME</code>, <code>NEW</code>, <code>AUTO</code>.
     *         </p>
     *         <p>
     *         <i>Default value</i>: <code>AUTO</code>.
     *         </p>
     *         <p class="title">
     *         <b/>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RESUME</code>   –   In RESUME mode, the loader looks for a previous load from this source, and if
     *         it finds one, resumes that load job. If no previous load job is found, the loader stops.
     *         </p>
     *         <p>
     *         The loader avoids reloading files that were successfully loaded in a previous job. It only tries to
     *         process failed files. If you dropped previously loaded data from your Neptune cluster, that data is not
     *         reloaded in this mode. If a previous load job loaded all files from the same source successfully, nothing
     *         is reloaded, and the loader returns success.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW</code>   –   In NEW mode, the creates a new load request regardless of any previous loads. You
     *         can use this mode to reload all the data from a source after dropping previously loaded data from your
     *         Neptune cluster, or to load new data available at the same source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTO</code>   –   In AUTO mode, the loader looks for a previous load job from the same source, and
     *         if it finds one, resumes that job, just as in <code>RESUME</code> mode.
     *         </p>
     *         <p>
     *         If the loader doesn't find a previous load job from the same source, it loads all data from the source,
     *         just as in <code>NEW</code> mode.
     *         </p>
     *         </li>
     * @see Mode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * <b> <code>failOnError</code> </b>   –   A flag to toggle a complete stop on an error.
     * </p>
     * <p>
     * <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
     * </p>
     * <p>
     * <i>Default value</i>: <code>"TRUE"</code>.
     * </p>
     * <p>
     * When this parameter is set to <code>"FALSE"</code>, the loader tries to load all the data in the location
     * specified, skipping any entries with errors.
     * </p>
     * <p>
     * When this parameter is set to <code>"TRUE"</code>, the loader stops as soon as it encounters an error. Data
     * loaded up to that point persists.
     * </p>
     * 
     * @return <b> <code>failOnError</code> </b>   –   A flag to toggle a complete stop on an error.</p>
     *         <p>
     *         <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
     *         </p>
     *         <p>
     *         <i>Default value</i>: <code>"TRUE"</code>.
     *         </p>
     *         <p>
     *         When this parameter is set to <code>"FALSE"</code>, the loader tries to load all the data in the location
     *         specified, skipping any entries with errors.
     *         </p>
     *         <p>
     *         When this parameter is set to <code>"TRUE"</code>, the loader stops as soon as it encounters an error.
     *         Data loaded up to that point persists.
     */
    public final Boolean failOnError() {
        return failOnError;
    }

    /**
     * <p>
     * The optional <code>parallelism</code> parameter can be set to reduce the number of threads used by the bulk load
     * process.
     * </p>
     * <p>
     * <i>Allowed values</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LOW</code> –   The number of threads used is the number of available vCPUs divided by 8.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code> –   The number of threads used is the number of available vCPUs divided by 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HIGH</code> –   The number of threads used is the same as the number of available vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OVERSUBSCRIBE</code> –   The number of threads used is the number of available vCPUs multiplied by 2. If
     * this value is used, the bulk loader takes up all available resources.
     * </p>
     * <p>
     * This does not mean, however, that the <code>OVERSUBSCRIBE</code> setting results in 100% CPU utilization. Because
     * the load operation is I/O bound, the highest CPU utilization to expect is in the 60% to 70% range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <i>Default value</i>: <code>HIGH</code>
     * </p>
     * <p>
     * The <code>parallelism</code> setting can sometimes result in a deadlock between threads when loading openCypher
     * data. When this happens, Neptune returns the <code>LOAD_DATA_DEADLOCK</code> error. You can generally fix the
     * issue by setting <code>parallelism</code> to a lower setting and retrying the load command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parallelism} will
     * return {@link Parallelism#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parallelismAsString}.
     * </p>
     * 
     * @return The optional <code>parallelism</code> parameter can be set to reduce the number of threads used by the
     *         bulk load process.</p>
     *         <p>
     *         <i>Allowed values</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LOW</code> –   The number of threads used is the number of available vCPUs divided by 8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code> –   The number of threads used is the number of available vCPUs divided by 2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HIGH</code> –   The number of threads used is the same as the number of available vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OVERSUBSCRIBE</code> –   The number of threads used is the number of available vCPUs multiplied by
     *         2. If this value is used, the bulk loader takes up all available resources.
     *         </p>
     *         <p>
     *         This does not mean, however, that the <code>OVERSUBSCRIBE</code> setting results in 100% CPU utilization.
     *         Because the load operation is I/O bound, the highest CPU utilization to expect is in the 60% to 70%
     *         range.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <i>Default value</i>: <code>HIGH</code>
     *         </p>
     *         <p>
     *         The <code>parallelism</code> setting can sometimes result in a deadlock between threads when loading
     *         openCypher data. When this happens, Neptune returns the <code>LOAD_DATA_DEADLOCK</code> error. You can
     *         generally fix the issue by setting <code>parallelism</code> to a lower setting and retrying the load
     *         command.
     * @see Parallelism
     */
    public final Parallelism parallelism() {
        return Parallelism.fromValue(parallelism);
    }

    /**
     * <p>
     * The optional <code>parallelism</code> parameter can be set to reduce the number of threads used by the bulk load
     * process.
     * </p>
     * <p>
     * <i>Allowed values</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LOW</code> –   The number of threads used is the number of available vCPUs divided by 8.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEDIUM</code> –   The number of threads used is the number of available vCPUs divided by 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HIGH</code> –   The number of threads used is the same as the number of available vCPUs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OVERSUBSCRIBE</code> –   The number of threads used is the number of available vCPUs multiplied by 2. If
     * this value is used, the bulk loader takes up all available resources.
     * </p>
     * <p>
     * This does not mean, however, that the <code>OVERSUBSCRIBE</code> setting results in 100% CPU utilization. Because
     * the load operation is I/O bound, the highest CPU utilization to expect is in the 60% to 70% range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <i>Default value</i>: <code>HIGH</code>
     * </p>
     * <p>
     * The <code>parallelism</code> setting can sometimes result in a deadlock between threads when loading openCypher
     * data. When this happens, Neptune returns the <code>LOAD_DATA_DEADLOCK</code> error. You can generally fix the
     * issue by setting <code>parallelism</code> to a lower setting and retrying the load command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parallelism} will
     * return {@link Parallelism#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parallelismAsString}.
     * </p>
     * 
     * @return The optional <code>parallelism</code> parameter can be set to reduce the number of threads used by the
     *         bulk load process.</p>
     *         <p>
     *         <i>Allowed values</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LOW</code> –   The number of threads used is the number of available vCPUs divided by 8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEDIUM</code> –   The number of threads used is the number of available vCPUs divided by 2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HIGH</code> –   The number of threads used is the same as the number of available vCPUs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OVERSUBSCRIBE</code> –   The number of threads used is the number of available vCPUs multiplied by
     *         2. If this value is used, the bulk loader takes up all available resources.
     *         </p>
     *         <p>
     *         This does not mean, however, that the <code>OVERSUBSCRIBE</code> setting results in 100% CPU utilization.
     *         Because the load operation is I/O bound, the highest CPU utilization to expect is in the 60% to 70%
     *         range.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <i>Default value</i>: <code>HIGH</code>
     *         </p>
     *         <p>
     *         The <code>parallelism</code> setting can sometimes result in a deadlock between threads when loading
     *         openCypher data. When this happens, Neptune returns the <code>LOAD_DATA_DEADLOCK</code> error. You can
     *         generally fix the issue by setting <code>parallelism</code> to a lower setting and retrying the load
     *         command.
     * @see Parallelism
     */
    public final String parallelismAsString() {
        return parallelism;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParserConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParserConfiguration() {
        return parserConfiguration != null && !(parserConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * <b> <code>parserConfiguration</code> </b>   –   An optional object with additional parser configuration values.
     * Each of the child parameters is also optional:
     * </p>
     * <p class="title">
     * <b/>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>namedGraphUri</code> </b>   –   The default graph for all RDF formats when no graph is specified (for
     * non-quads formats and NQUAD entries with no graph).
     * </p>
     * <p>
     * The default is <code>https://aws.amazon.com/neptune/vocab/v01/DefaultNamedGraph</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>baseUri</code> </b>   –   The base URI for RDF/XML and Turtle formats.
     * </p>
     * <p>
     * The default is <code>https://aws.amazon.com/neptune/default</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>allowEmptyStrings</code> </b>   –   Gremlin users need to be able to pass empty string values("") as
     * node and edge properties when loading CSV data. If <code>allowEmptyStrings</code> is set to <code>false</code>
     * (the default), such empty strings are treated as nulls and are not loaded.
     * </p>
     * <p>
     * If <code>allowEmptyStrings</code> is set to <code>true</code>, the loader treats empty strings as valid property
     * values and loads them accordingly.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParserConfiguration} method.
     * </p>
     * 
     * @return <b> <code>parserConfiguration</code> </b>   –   An optional object with additional parser configuration
     *         values. Each of the child parameters is also optional:</p>
     *         <p class="title">
     *         <b/>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>namedGraphUri</code> </b>   –   The default graph for all RDF formats when no graph is
     *         specified (for non-quads formats and NQUAD entries with no graph).
     *         </p>
     *         <p>
     *         The default is <code>https://aws.amazon.com/neptune/vocab/v01/DefaultNamedGraph</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>baseUri</code> </b>   –   The base URI for RDF/XML and Turtle formats.
     *         </p>
     *         <p>
     *         The default is <code>https://aws.amazon.com/neptune/default</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>allowEmptyStrings</code> </b>   –   Gremlin users need to be able to pass empty string
     *         values("") as node and edge properties when loading CSV data. If <code>allowEmptyStrings</code> is set to
     *         <code>false</code> (the default), such empty strings are treated as nulls and are not loaded.
     *         </p>
     *         <p>
     *         If <code>allowEmptyStrings</code> is set to <code>true</code>, the loader treats empty strings as valid
     *         property values and loads them accordingly.
     *         </p>
     *         </li>
     */
    public final Map<String, String> parserConfiguration() {
        return parserConfiguration;
    }

    /**
     * <p>
     * <code>updateSingleCardinalityProperties</code> is an optional parameter that controls how the bulk loader treats
     * a new value for single-cardinality vertex or edge properties. This is not supported for loading openCypher data.
     * </p>
     * <p>
     * <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
     * </p>
     * <p>
     * <i>Default value</i>: <code>"FALSE"</code>.
     * </p>
     * <p>
     * By default, or when <code>updateSingleCardinalityProperties</code> is explicitly set to <code>"FALSE"</code>, the
     * loader treats a new value as an error, because it violates single cardinality.
     * </p>
     * <p>
     * When <code>updateSingleCardinalityProperties</code> is set to <code>"TRUE"</code>, on the other hand, the bulk
     * loader replaces the existing value with the new one. If multiple edge or single-cardinality vertex property
     * values are provided in the source file(s) being loaded, the final value at the end of the bulk load could be any
     * one of those new values. The loader only guarantees that the existing value has been replaced by one of the new
     * ones.
     * </p>
     * 
     * @return <code>updateSingleCardinalityProperties</code> is an optional parameter that controls how the bulk loader
     *         treats a new value for single-cardinality vertex or edge properties. This is not supported for loading
     *         openCypher data.</p>
     *         <p>
     *         <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
     *         </p>
     *         <p>
     *         <i>Default value</i>: <code>"FALSE"</code>.
     *         </p>
     *         <p>
     *         By default, or when <code>updateSingleCardinalityProperties</code> is explicitly set to
     *         <code>"FALSE"</code>, the loader treats a new value as an error, because it violates single cardinality.
     *         </p>
     *         <p>
     *         When <code>updateSingleCardinalityProperties</code> is set to <code>"TRUE"</code>, on the other hand, the
     *         bulk loader replaces the existing value with the new one. If multiple edge or single-cardinality vertex
     *         property values are provided in the source file(s) being loaded, the final value at the end of the bulk
     *         load could be any one of those new values. The loader only guarantees that the existing value has been
     *         replaced by one of the new ones.
     */
    public final Boolean updateSingleCardinalityProperties() {
        return updateSingleCardinalityProperties;
    }

    /**
     * <p>
     * This is an optional flag parameter that indicates whether the load request can be queued up or not.
     * </p>
     * <p>
     * You don't have to wait for one load job to complete before issuing the next one, because Neptune can queue up as
     * many as 64 jobs at a time, provided that their <code>queueRequest</code> parameters are all set to
     * <code>"TRUE"</code>. The queue order of the jobs will be first-in-first-out (FIFO).
     * </p>
     * <p>
     * If the <code>queueRequest</code> parameter is omitted or set to <code>"FALSE"</code>, the load request will fail
     * if another load job is already running.
     * </p>
     * <p>
     * <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
     * </p>
     * <p>
     * <i>Default value</i>: <code>"FALSE"</code>.
     * </p>
     * 
     * @return This is an optional flag parameter that indicates whether the load request can be queued up or not. </p>
     *         <p>
     *         You don't have to wait for one load job to complete before issuing the next one, because Neptune can
     *         queue up as many as 64 jobs at a time, provided that their <code>queueRequest</code> parameters are all
     *         set to <code>"TRUE"</code>. The queue order of the jobs will be first-in-first-out (FIFO).
     *         </p>
     *         <p>
     *         If the <code>queueRequest</code> parameter is omitted or set to <code>"FALSE"</code>, the load request
     *         will fail if another load job is already running.
     *         </p>
     *         <p>
     *         <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
     *         </p>
     *         <p>
     *         <i>Default value</i>: <code>"FALSE"</code>.
     */
    public final Boolean queueRequest() {
        return queueRequest;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dependencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is an optional parameter that can make a queued load request contingent on the successful completion of one
     * or more previous jobs in the queue.
     * </p>
     * <p>
     * Neptune can queue up as many as 64 load requests at a time, if their <code>queueRequest</code> parameters are set
     * to <code>"TRUE"</code>. The <code>dependencies</code> parameter lets you make execution of such a queued request
     * dependent on the successful completion of one or more specified previous requests in the queue.
     * </p>
     * <p>
     * For example, if load <code>Job-A</code> and <code>Job-B</code> are independent of each other, but load
     * <code>Job-C</code> needs <code>Job-A</code> and <code>Job-B</code> to be finished before it begins, proceed as
     * follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit <code>load-job-A</code> and <code>load-job-B</code> one after another in any order, and save their
     * load-ids.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit <code>load-job-C</code> with the load-ids of the two jobs in its <code>dependencies</code> field:
     * </p>
     * </li>
     * </ol>
     * <p>
     * Because of the <code>dependencies</code> parameter, the bulk loader will not start <code>Job-C</code> until
     * <code>Job-A</code> and <code>Job-B</code> have completed successfully. If either one of them fails, Job-C will
     * not be executed, and its status will be set to <code>LOAD_FAILED_BECAUSE_DEPENDENCY_NOT_SATISFIED</code>.
     * </p>
     * <p>
     * You can set up multiple levels of dependency in this way, so that the failure of one job will cause all requests
     * that are directly or indirectly dependent on it to be cancelled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencies} method.
     * </p>
     * 
     * @return This is an optional parameter that can make a queued load request contingent on the successful completion
     *         of one or more previous jobs in the queue.</p>
     *         <p>
     *         Neptune can queue up as many as 64 load requests at a time, if their <code>queueRequest</code> parameters
     *         are set to <code>"TRUE"</code>. The <code>dependencies</code> parameter lets you make execution of such a
     *         queued request dependent on the successful completion of one or more specified previous requests in the
     *         queue.
     *         </p>
     *         <p>
     *         For example, if load <code>Job-A</code> and <code>Job-B</code> are independent of each other, but load
     *         <code>Job-C</code> needs <code>Job-A</code> and <code>Job-B</code> to be finished before it begins,
     *         proceed as follows:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Submit <code>load-job-A</code> and <code>load-job-B</code> one after another in any order, and save their
     *         load-ids.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Submit <code>load-job-C</code> with the load-ids of the two jobs in its <code>dependencies</code> field:
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         Because of the <code>dependencies</code> parameter, the bulk loader will not start <code>Job-C</code>
     *         until <code>Job-A</code> and <code>Job-B</code> have completed successfully. If either one of them fails,
     *         Job-C will not be executed, and its status will be set to
     *         <code>LOAD_FAILED_BECAUSE_DEPENDENCY_NOT_SATISFIED</code>.
     *         </p>
     *         <p>
     *         You can set up multiple levels of dependency in this way, so that the failure of one job will cause all
     *         requests that are directly or indirectly dependent on it to be cancelled.
     */
    public final List<String> dependencies() {
        return dependencies;
    }

    /**
     * <p>
     * This parameter is required only when loading openCypher data that contains relationship IDs. It must be included
     * and set to <code>True</code> when openCypher relationship IDs are explicitly provided in the load data
     * (recommended).
     * </p>
     * <p>
     * When <code>userProvidedEdgeIds</code> is absent or set to <code>True</code>, an <code>:ID</code> column must be
     * present in every relationship file in the load.
     * </p>
     * <p>
     * When <code>userProvidedEdgeIds</code> is present and set to <code>False</code>, relationship files in the load
     * <b>must not</b> contain an <code>:ID</code> column. Instead, the Neptune loader automatically generates an ID for
     * each relationship.
     * </p>
     * <p>
     * It's useful to provide relationship IDs explicitly so that the loader can resume loading after error in the CSV
     * data have been fixed, without having to reload any relationships that have already been loaded. If relationship
     * IDs have not been explicitly assigned, the loader cannot resume a failed load if any relationship file has had to
     * be corrected, and must instead reload all the relationships.
     * </p>
     * 
     * @return This parameter is required only when loading openCypher data that contains relationship IDs. It must be
     *         included and set to <code>True</code> when openCypher relationship IDs are explicitly provided in the
     *         load data (recommended).</p>
     *         <p>
     *         When <code>userProvidedEdgeIds</code> is absent or set to <code>True</code>, an <code>:ID</code> column
     *         must be present in every relationship file in the load.
     *         </p>
     *         <p>
     *         When <code>userProvidedEdgeIds</code> is present and set to <code>False</code>, relationship files in the
     *         load <b>must not</b> contain an <code>:ID</code> column. Instead, the Neptune loader automatically
     *         generates an ID for each relationship.
     *         </p>
     *         <p>
     *         It's useful to provide relationship IDs explicitly so that the loader can resume loading after error in
     *         the CSV data have been fixed, without having to reload any relationships that have already been loaded.
     *         If relationship IDs have not been explicitly assigned, the loader cannot resume a failed load if any
     *         relationship file has had to be corrected, and must instead reload all the relationships.
     */
    public final Boolean userProvidedEdgeIds() {
        return userProvidedEdgeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failOnError());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasParserConfiguration() ? parserConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateSingleCardinalityProperties());
        hashCode = 31 * hashCode + Objects.hashCode(queueRequest());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userProvidedEdgeIds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLoaderJobRequest)) {
            return false;
        }
        StartLoaderJobRequest other = (StartLoaderJobRequest) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(s3BucketRegionAsString(), other.s3BucketRegionAsString())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(failOnError(), other.failOnError())
                && Objects.equals(parallelismAsString(), other.parallelismAsString())
                && hasParserConfiguration() == other.hasParserConfiguration()
                && Objects.equals(parserConfiguration(), other.parserConfiguration())
                && Objects.equals(updateSingleCardinalityProperties(), other.updateSingleCardinalityProperties())
                && Objects.equals(queueRequest(), other.queueRequest()) && hasDependencies() == other.hasDependencies()
                && Objects.equals(dependencies(), other.dependencies())
                && Objects.equals(userProvidedEdgeIds(), other.userProvidedEdgeIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartLoaderJobRequest").add("Source", source()).add("Format", formatAsString())
                .add("S3BucketRegion", s3BucketRegionAsString()).add("IamRoleArn", iamRoleArn()).add("Mode", modeAsString())
                .add("FailOnError", failOnError()).add("Parallelism", parallelismAsString())
                .add("ParserConfiguration", hasParserConfiguration() ? parserConfiguration() : null)
                .add("UpdateSingleCardinalityProperties", updateSingleCardinalityProperties())
                .add("QueueRequest", queueRequest()).add("Dependencies", hasDependencies() ? dependencies() : null)
                .add("UserProvidedEdgeIds", userProvidedEdgeIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "s3BucketRegion":
            return Optional.ofNullable(clazz.cast(s3BucketRegionAsString()));
        case "iamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "failOnError":
            return Optional.ofNullable(clazz.cast(failOnError()));
        case "parallelism":
            return Optional.ofNullable(clazz.cast(parallelismAsString()));
        case "parserConfiguration":
            return Optional.ofNullable(clazz.cast(parserConfiguration()));
        case "updateSingleCardinalityProperties":
            return Optional.ofNullable(clazz.cast(updateSingleCardinalityProperties()));
        case "queueRequest":
            return Optional.ofNullable(clazz.cast(queueRequest()));
        case "dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        case "userProvidedEdgeIds":
            return Optional.ofNullable(clazz.cast(userProvidedEdgeIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("region", S3_BUCKET_REGION_FIELD);
        map.put("iamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("failOnError", FAIL_ON_ERROR_FIELD);
        map.put("parallelism", PARALLELISM_FIELD);
        map.put("parserConfiguration", PARSER_CONFIGURATION_FIELD);
        map.put("updateSingleCardinalityProperties", UPDATE_SINGLE_CARDINALITY_PROPERTIES_FIELD);
        map.put("queueRequest", QUEUE_REQUEST_FIELD);
        map.put("dependencies", DEPENDENCIES_FIELD);
        map.put("userProvidedEdgeIds", USER_PROVIDED_EDGE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartLoaderJobRequest, T> g) {
        return obj -> g.apply((StartLoaderJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartLoaderJobRequest> {
        /**
         * <p>
         * The <code>source</code> parameter accepts an S3 URI that identifies a single file, multiple files, a folder,
         * or multiple folders. Neptune loads every data file in any folder that is specified.
         * </p>
         * <p>
         * The URI can be in any of the following formats.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>s3://(bucket_name)/(object-key-name)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https://s3.amazonaws.com/(bucket_name)/(object-key-name)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https://s3.us-east-1.amazonaws.com/(bucket_name)/(object-key-name)</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The <code>object-key-name</code> element of the URI is equivalent to the <a href=
         * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html#API_ListObjects_RequestParameters"
         * >prefix</a> parameter in an S3 <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a> API call. It
         * identifies all the objects in the specified S3 bucket whose names begin with that prefix. That can be a
         * single file or folder, or multiple files and/or folders.
         * </p>
         * <p>
         * The specified folder or folders can contain multiple vertex files and multiple edge files.
         * </p>
         * 
         * @param source
         *        The <code>source</code> parameter accepts an S3 URI that identifies a single file, multiple files, a
         *        folder, or multiple folders. Neptune loads every data file in any folder that is specified.</p>
         *        <p>
         *        The URI can be in any of the following formats.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>s3://(bucket_name)/(object-key-name)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https://s3.amazonaws.com/(bucket_name)/(object-key-name)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https://s3.us-east-1.amazonaws.com/(bucket_name)/(object-key-name)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The <code>object-key-name</code> element of the URI is equivalent to the <a href=
         *        "https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html#API_ListObjects_RequestParameters"
         *        >prefix</a> parameter in an S3 <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a> API call.
         *        It identifies all the objects in the specified S3 bucket whose names begin with that prefix. That can
         *        be a single file or folder, or multiple files and/or folders.
         *        </p>
         *        <p>
         *        The specified folder or folders can contain multiple vertex files and multiple edge files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The format of the data. For more information about data formats for the Neptune <code>Loader</code> command,
         * see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html">Load Data
         * Formats</a>.
         * </p>
         * <p class="title">
         * <b>Allowed values</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>csv</code> </b> for the <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin
         * CSV data format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>opencypher</code> </b> for the <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
         * >openCypher CSV data format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>ntriples</code> </b> for the <a href="https://www.w3.org/TR/n-triples/">N-Triples RDF data
         * format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>nquads</code> </b> for the <a href="https://www.w3.org/TR/n-quads/">N-Quads RDF data format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>rdfxml</code> </b> for the <a href="https://www.w3.org/TR/rdf-syntax-grammar/">RDF\XML RDF data
         * format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>turtle</code> </b> for the <a href="https://www.w3.org/TR/turtle/">Turtle RDF data format</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        The format of the data. For more information about data formats for the Neptune <code>Loader</code>
         *        command, see <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html">Load Data
         *        Formats</a>.</p>
         *        <p class="title">
         *        <b>Allowed values</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>csv</code> </b> for the <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html"
         *        >Gremlin CSV data format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>opencypher</code> </b> for the <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
         *        >openCypher CSV data format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>ntriples</code> </b> for the <a href="https://www.w3.org/TR/n-triples/">N-Triples RDF data
         *        format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>nquads</code> </b> for the <a href="https://www.w3.org/TR/n-quads/">N-Quads RDF data
         *        format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>rdfxml</code> </b> for the <a href="https://www.w3.org/TR/rdf-syntax-grammar/">RDF\XML RDF
         *        data format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>turtle</code> </b> for the <a href="https://www.w3.org/TR/turtle/">Turtle RDF data
         *        format</a>.
         *        </p>
         *        </li>
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the data. For more information about data formats for the Neptune <code>Loader</code> command,
         * see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html">Load Data
         * Formats</a>.
         * </p>
         * <p class="title">
         * <b>Allowed values</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>csv</code> </b> for the <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin
         * CSV data format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>opencypher</code> </b> for the <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
         * >openCypher CSV data format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>ntriples</code> </b> for the <a href="https://www.w3.org/TR/n-triples/">N-Triples RDF data
         * format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>nquads</code> </b> for the <a href="https://www.w3.org/TR/n-quads/">N-Quads RDF data format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>rdfxml</code> </b> for the <a href="https://www.w3.org/TR/rdf-syntax-grammar/">RDF\XML RDF data
         * format</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>turtle</code> </b> for the <a href="https://www.w3.org/TR/turtle/">Turtle RDF data format</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        The format of the data. For more information about data formats for the Neptune <code>Loader</code>
         *        command, see <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html">Load Data
         *        Formats</a>.</p>
         *        <p class="title">
         *        <b>Allowed values</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>csv</code> </b> for the <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html"
         *        >Gremlin CSV data format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>opencypher</code> </b> for the <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
         *        >openCypher CSV data format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>ntriples</code> </b> for the <a href="https://www.w3.org/TR/n-triples/">N-Triples RDF data
         *        format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>nquads</code> </b> for the <a href="https://www.w3.org/TR/n-quads/">N-Quads RDF data
         *        format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>rdfxml</code> </b> for the <a href="https://www.w3.org/TR/rdf-syntax-grammar/">RDF\XML RDF
         *        data format</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>turtle</code> </b> for the <a href="https://www.w3.org/TR/turtle/">Turtle RDF data
         *        format</a>.
         *        </p>
         *        </li>
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * The Amazon region of the S3 bucket. This must match the Amazon Region of the DB cluster.
         * </p>
         * 
         * @param s3BucketRegion
         *        The Amazon region of the S3 bucket. This must match the Amazon Region of the DB cluster.
         * @see S3BucketRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3BucketRegion
         */
        Builder s3BucketRegion(String s3BucketRegion);

        /**
         * <p>
         * The Amazon region of the S3 bucket. This must match the Amazon Region of the DB cluster.
         * </p>
         * 
         * @param s3BucketRegion
         *        The Amazon region of the S3 bucket. This must match the Amazon Region of the DB cluster.
         * @see S3BucketRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3BucketRegion
         */
        Builder s3BucketRegion(S3BucketRegion s3BucketRegion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for an IAM role to be assumed by the Neptune DB instance for access to the S3
         * bucket. The IAM role ARN provided here should be attached to the DB cluster (see <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-IAM-add-role-cluster.html"
         * >Adding the IAM Role to an Amazon Neptune Cluster</a>.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) for an IAM role to be assumed by the Neptune DB instance for access to
         *        the S3 bucket. The IAM role ARN provided here should be attached to the DB cluster (see <a href=
         *        "https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-IAM-add-role-cluster.html"
         *        >Adding the IAM Role to an Amazon Neptune Cluster</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The load job mode.
         * </p>
         * <p>
         * <i>Allowed values</i>: <code>RESUME</code>, <code>NEW</code>, <code>AUTO</code>.
         * </p>
         * <p>
         * <i>Default value</i>: <code>AUTO</code>.
         * </p>
         * <p class="title">
         * <b/>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RESUME</code>   –   In RESUME mode, the loader looks for a previous load from this source, and if it
         * finds one, resumes that load job. If no previous load job is found, the loader stops.
         * </p>
         * <p>
         * The loader avoids reloading files that were successfully loaded in a previous job. It only tries to process
         * failed files. If you dropped previously loaded data from your Neptune cluster, that data is not reloaded in
         * this mode. If a previous load job loaded all files from the same source successfully, nothing is reloaded,
         * and the loader returns success.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW</code>   –   In NEW mode, the creates a new load request regardless of any previous loads. You can
         * use this mode to reload all the data from a source after dropping previously loaded data from your Neptune
         * cluster, or to load new data available at the same source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTO</code>   –   In AUTO mode, the loader looks for a previous load job from the same source, and if
         * it finds one, resumes that job, just as in <code>RESUME</code> mode.
         * </p>
         * <p>
         * If the loader doesn't find a previous load job from the same source, it loads all data from the source, just
         * as in <code>NEW</code> mode.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        The load job mode.</p>
         *        <p>
         *        <i>Allowed values</i>: <code>RESUME</code>, <code>NEW</code>, <code>AUTO</code>.
         *        </p>
         *        <p>
         *        <i>Default value</i>: <code>AUTO</code>.
         *        </p>
         *        <p class="title">
         *        <b/>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RESUME</code>   –   In RESUME mode, the loader looks for a previous load from this source, and
         *        if it finds one, resumes that load job. If no previous load job is found, the loader stops.
         *        </p>
         *        <p>
         *        The loader avoids reloading files that were successfully loaded in a previous job. It only tries to
         *        process failed files. If you dropped previously loaded data from your Neptune cluster, that data is
         *        not reloaded in this mode. If a previous load job loaded all files from the same source successfully,
         *        nothing is reloaded, and the loader returns success.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW</code>   –   In NEW mode, the creates a new load request regardless of any previous loads.
         *        You can use this mode to reload all the data from a source after dropping previously loaded data from
         *        your Neptune cluster, or to load new data available at the same source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTO</code>   –   In AUTO mode, the loader looks for a previous load job from the same source,
         *        and if it finds one, resumes that job, just as in <code>RESUME</code> mode.
         *        </p>
         *        <p>
         *        If the loader doesn't find a previous load job from the same source, it loads all data from the
         *        source, just as in <code>NEW</code> mode.
         *        </p>
         *        </li>
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The load job mode.
         * </p>
         * <p>
         * <i>Allowed values</i>: <code>RESUME</code>, <code>NEW</code>, <code>AUTO</code>.
         * </p>
         * <p>
         * <i>Default value</i>: <code>AUTO</code>.
         * </p>
         * <p class="title">
         * <b/>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RESUME</code>   –   In RESUME mode, the loader looks for a previous load from this source, and if it
         * finds one, resumes that load job. If no previous load job is found, the loader stops.
         * </p>
         * <p>
         * The loader avoids reloading files that were successfully loaded in a previous job. It only tries to process
         * failed files. If you dropped previously loaded data from your Neptune cluster, that data is not reloaded in
         * this mode. If a previous load job loaded all files from the same source successfully, nothing is reloaded,
         * and the loader returns success.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW</code>   –   In NEW mode, the creates a new load request regardless of any previous loads. You can
         * use this mode to reload all the data from a source after dropping previously loaded data from your Neptune
         * cluster, or to load new data available at the same source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTO</code>   –   In AUTO mode, the loader looks for a previous load job from the same source, and if
         * it finds one, resumes that job, just as in <code>RESUME</code> mode.
         * </p>
         * <p>
         * If the loader doesn't find a previous load job from the same source, it loads all data from the source, just
         * as in <code>NEW</code> mode.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        The load job mode.</p>
         *        <p>
         *        <i>Allowed values</i>: <code>RESUME</code>, <code>NEW</code>, <code>AUTO</code>.
         *        </p>
         *        <p>
         *        <i>Default value</i>: <code>AUTO</code>.
         *        </p>
         *        <p class="title">
         *        <b/>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RESUME</code>   –   In RESUME mode, the loader looks for a previous load from this source, and
         *        if it finds one, resumes that load job. If no previous load job is found, the loader stops.
         *        </p>
         *        <p>
         *        The loader avoids reloading files that were successfully loaded in a previous job. It only tries to
         *        process failed files. If you dropped previously loaded data from your Neptune cluster, that data is
         *        not reloaded in this mode. If a previous load job loaded all files from the same source successfully,
         *        nothing is reloaded, and the loader returns success.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW</code>   –   In NEW mode, the creates a new load request regardless of any previous loads.
         *        You can use this mode to reload all the data from a source after dropping previously loaded data from
         *        your Neptune cluster, or to load new data available at the same source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTO</code>   –   In AUTO mode, the loader looks for a previous load job from the same source,
         *        and if it finds one, resumes that job, just as in <code>RESUME</code> mode.
         *        </p>
         *        <p>
         *        If the loader doesn't find a previous load job from the same source, it loads all data from the
         *        source, just as in <code>NEW</code> mode.
         *        </p>
         *        </li>
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(Mode mode);

        /**
         * <p>
         * <b> <code>failOnError</code> </b>   –   A flag to toggle a complete stop on an error.
         * </p>
         * <p>
         * <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
         * </p>
         * <p>
         * <i>Default value</i>: <code>"TRUE"</code>.
         * </p>
         * <p>
         * When this parameter is set to <code>"FALSE"</code>, the loader tries to load all the data in the location
         * specified, skipping any entries with errors.
         * </p>
         * <p>
         * When this parameter is set to <code>"TRUE"</code>, the loader stops as soon as it encounters an error. Data
         * loaded up to that point persists.
         * </p>
         * 
         * @param failOnError
         *        <b> <code>failOnError</code> </b>   –   A flag to toggle a complete stop on an error.</p>
         *        <p>
         *        <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
         *        </p>
         *        <p>
         *        <i>Default value</i>: <code>"TRUE"</code>.
         *        </p>
         *        <p>
         *        When this parameter is set to <code>"FALSE"</code>, the loader tries to load all the data in the
         *        location specified, skipping any entries with errors.
         *        </p>
         *        <p>
         *        When this parameter is set to <code>"TRUE"</code>, the loader stops as soon as it encounters an error.
         *        Data loaded up to that point persists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failOnError(Boolean failOnError);

        /**
         * <p>
         * The optional <code>parallelism</code> parameter can be set to reduce the number of threads used by the bulk
         * load process.
         * </p>
         * <p>
         * <i>Allowed values</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LOW</code> –   The number of threads used is the number of available vCPUs divided by 8.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code> –   The number of threads used is the number of available vCPUs divided by 2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HIGH</code> –   The number of threads used is the same as the number of available vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OVERSUBSCRIBE</code> –   The number of threads used is the number of available vCPUs multiplied by 2.
         * If this value is used, the bulk loader takes up all available resources.
         * </p>
         * <p>
         * This does not mean, however, that the <code>OVERSUBSCRIBE</code> setting results in 100% CPU utilization.
         * Because the load operation is I/O bound, the highest CPU utilization to expect is in the 60% to 70% range.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <i>Default value</i>: <code>HIGH</code>
         * </p>
         * <p>
         * The <code>parallelism</code> setting can sometimes result in a deadlock between threads when loading
         * openCypher data. When this happens, Neptune returns the <code>LOAD_DATA_DEADLOCK</code> error. You can
         * generally fix the issue by setting <code>parallelism</code> to a lower setting and retrying the load command.
         * </p>
         * 
         * @param parallelism
         *        The optional <code>parallelism</code> parameter can be set to reduce the number of threads used by the
         *        bulk load process.</p>
         *        <p>
         *        <i>Allowed values</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LOW</code> –   The number of threads used is the number of available vCPUs divided by 8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code> –   The number of threads used is the number of available vCPUs divided by 2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HIGH</code> –   The number of threads used is the same as the number of available vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OVERSUBSCRIBE</code> –   The number of threads used is the number of available vCPUs multiplied
         *        by 2. If this value is used, the bulk loader takes up all available resources.
         *        </p>
         *        <p>
         *        This does not mean, however, that the <code>OVERSUBSCRIBE</code> setting results in 100% CPU
         *        utilization. Because the load operation is I/O bound, the highest CPU utilization to expect is in the
         *        60% to 70% range.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <i>Default value</i>: <code>HIGH</code>
         *        </p>
         *        <p>
         *        The <code>parallelism</code> setting can sometimes result in a deadlock between threads when loading
         *        openCypher data. When this happens, Neptune returns the <code>LOAD_DATA_DEADLOCK</code> error. You can
         *        generally fix the issue by setting <code>parallelism</code> to a lower setting and retrying the load
         *        command.
         * @see Parallelism
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Parallelism
         */
        Builder parallelism(String parallelism);

        /**
         * <p>
         * The optional <code>parallelism</code> parameter can be set to reduce the number of threads used by the bulk
         * load process.
         * </p>
         * <p>
         * <i>Allowed values</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LOW</code> –   The number of threads used is the number of available vCPUs divided by 8.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEDIUM</code> –   The number of threads used is the number of available vCPUs divided by 2.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HIGH</code> –   The number of threads used is the same as the number of available vCPUs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OVERSUBSCRIBE</code> –   The number of threads used is the number of available vCPUs multiplied by 2.
         * If this value is used, the bulk loader takes up all available resources.
         * </p>
         * <p>
         * This does not mean, however, that the <code>OVERSUBSCRIBE</code> setting results in 100% CPU utilization.
         * Because the load operation is I/O bound, the highest CPU utilization to expect is in the 60% to 70% range.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <i>Default value</i>: <code>HIGH</code>
         * </p>
         * <p>
         * The <code>parallelism</code> setting can sometimes result in a deadlock between threads when loading
         * openCypher data. When this happens, Neptune returns the <code>LOAD_DATA_DEADLOCK</code> error. You can
         * generally fix the issue by setting <code>parallelism</code> to a lower setting and retrying the load command.
         * </p>
         * 
         * @param parallelism
         *        The optional <code>parallelism</code> parameter can be set to reduce the number of threads used by the
         *        bulk load process.</p>
         *        <p>
         *        <i>Allowed values</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LOW</code> –   The number of threads used is the number of available vCPUs divided by 8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEDIUM</code> –   The number of threads used is the number of available vCPUs divided by 2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HIGH</code> –   The number of threads used is the same as the number of available vCPUs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OVERSUBSCRIBE</code> –   The number of threads used is the number of available vCPUs multiplied
         *        by 2. If this value is used, the bulk loader takes up all available resources.
         *        </p>
         *        <p>
         *        This does not mean, however, that the <code>OVERSUBSCRIBE</code> setting results in 100% CPU
         *        utilization. Because the load operation is I/O bound, the highest CPU utilization to expect is in the
         *        60% to 70% range.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <i>Default value</i>: <code>HIGH</code>
         *        </p>
         *        <p>
         *        The <code>parallelism</code> setting can sometimes result in a deadlock between threads when loading
         *        openCypher data. When this happens, Neptune returns the <code>LOAD_DATA_DEADLOCK</code> error. You can
         *        generally fix the issue by setting <code>parallelism</code> to a lower setting and retrying the load
         *        command.
         * @see Parallelism
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Parallelism
         */
        Builder parallelism(Parallelism parallelism);

        /**
         * <p>
         * <b> <code>parserConfiguration</code> </b>   –   An optional object with additional parser configuration
         * values. Each of the child parameters is also optional:
         * </p>
         * <p class="title">
         * <b/>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>namedGraphUri</code> </b>   –   The default graph for all RDF formats when no graph is specified
         * (for non-quads formats and NQUAD entries with no graph).
         * </p>
         * <p>
         * The default is <code>https://aws.amazon.com/neptune/vocab/v01/DefaultNamedGraph</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>baseUri</code> </b>   –   The base URI for RDF/XML and Turtle formats.
         * </p>
         * <p>
         * The default is <code>https://aws.amazon.com/neptune/default</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>allowEmptyStrings</code> </b>   –   Gremlin users need to be able to pass empty string values("")
         * as node and edge properties when loading CSV data. If <code>allowEmptyStrings</code> is set to
         * <code>false</code> (the default), such empty strings are treated as nulls and are not loaded.
         * </p>
         * <p>
         * If <code>allowEmptyStrings</code> is set to <code>true</code>, the loader treats empty strings as valid
         * property values and loads them accordingly.
         * </p>
         * </li>
         * </ul>
         * 
         * @param parserConfiguration
         *        <b> <code>parserConfiguration</code> </b>   –   An optional object with additional parser
         *        configuration values. Each of the child parameters is also optional:</p>
         *        <p class="title">
         *        <b/>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>namedGraphUri</code> </b>   –   The default graph for all RDF formats when no graph is
         *        specified (for non-quads formats and NQUAD entries with no graph).
         *        </p>
         *        <p>
         *        The default is <code>https://aws.amazon.com/neptune/vocab/v01/DefaultNamedGraph</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>baseUri</code> </b>   –   The base URI for RDF/XML and Turtle formats.
         *        </p>
         *        <p>
         *        The default is <code>https://aws.amazon.com/neptune/default</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>allowEmptyStrings</code> </b>   –   Gremlin users need to be able to pass empty string
         *        values("") as node and edge properties when loading CSV data. If <code>allowEmptyStrings</code> is set
         *        to <code>false</code> (the default), such empty strings are treated as nulls and are not loaded.
         *        </p>
         *        <p>
         *        If <code>allowEmptyStrings</code> is set to <code>true</code>, the loader treats empty strings as
         *        valid property values and loads them accordingly.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parserConfiguration(Map<String, String> parserConfiguration);

        /**
         * <p>
         * <code>updateSingleCardinalityProperties</code> is an optional parameter that controls how the bulk loader
         * treats a new value for single-cardinality vertex or edge properties. This is not supported for loading
         * openCypher data.
         * </p>
         * <p>
         * <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
         * </p>
         * <p>
         * <i>Default value</i>: <code>"FALSE"</code>.
         * </p>
         * <p>
         * By default, or when <code>updateSingleCardinalityProperties</code> is explicitly set to <code>"FALSE"</code>,
         * the loader treats a new value as an error, because it violates single cardinality.
         * </p>
         * <p>
         * When <code>updateSingleCardinalityProperties</code> is set to <code>"TRUE"</code>, on the other hand, the
         * bulk loader replaces the existing value with the new one. If multiple edge or single-cardinality vertex
         * property values are provided in the source file(s) being loaded, the final value at the end of the bulk load
         * could be any one of those new values. The loader only guarantees that the existing value has been replaced by
         * one of the new ones.
         * </p>
         * 
         * @param updateSingleCardinalityProperties
         *        <code>updateSingleCardinalityProperties</code> is an optional parameter that controls how the bulk
         *        loader treats a new value for single-cardinality vertex or edge properties. This is not supported for
         *        loading openCypher data.</p>
         *        <p>
         *        <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
         *        </p>
         *        <p>
         *        <i>Default value</i>: <code>"FALSE"</code>.
         *        </p>
         *        <p>
         *        By default, or when <code>updateSingleCardinalityProperties</code> is explicitly set to
         *        <code>"FALSE"</code>, the loader treats a new value as an error, because it violates single
         *        cardinality.
         *        </p>
         *        <p>
         *        When <code>updateSingleCardinalityProperties</code> is set to <code>"TRUE"</code>, on the other hand,
         *        the bulk loader replaces the existing value with the new one. If multiple edge or single-cardinality
         *        vertex property values are provided in the source file(s) being loaded, the final value at the end of
         *        the bulk load could be any one of those new values. The loader only guarantees that the existing value
         *        has been replaced by one of the new ones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateSingleCardinalityProperties(Boolean updateSingleCardinalityProperties);

        /**
         * <p>
         * This is an optional flag parameter that indicates whether the load request can be queued up or not.
         * </p>
         * <p>
         * You don't have to wait for one load job to complete before issuing the next one, because Neptune can queue up
         * as many as 64 jobs at a time, provided that their <code>queueRequest</code> parameters are all set to
         * <code>"TRUE"</code>. The queue order of the jobs will be first-in-first-out (FIFO).
         * </p>
         * <p>
         * If the <code>queueRequest</code> parameter is omitted or set to <code>"FALSE"</code>, the load request will
         * fail if another load job is already running.
         * </p>
         * <p>
         * <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
         * </p>
         * <p>
         * <i>Default value</i>: <code>"FALSE"</code>.
         * </p>
         * 
         * @param queueRequest
         *        This is an optional flag parameter that indicates whether the load request can be queued up or not.
         *        </p>
         *        <p>
         *        You don't have to wait for one load job to complete before issuing the next one, because Neptune can
         *        queue up as many as 64 jobs at a time, provided that their <code>queueRequest</code> parameters are
         *        all set to <code>"TRUE"</code>. The queue order of the jobs will be first-in-first-out (FIFO).
         *        </p>
         *        <p>
         *        If the <code>queueRequest</code> parameter is omitted or set to <code>"FALSE"</code>, the load request
         *        will fail if another load job is already running.
         *        </p>
         *        <p>
         *        <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.
         *        </p>
         *        <p>
         *        <i>Default value</i>: <code>"FALSE"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueRequest(Boolean queueRequest);

        /**
         * <p>
         * This is an optional parameter that can make a queued load request contingent on the successful completion of
         * one or more previous jobs in the queue.
         * </p>
         * <p>
         * Neptune can queue up as many as 64 load requests at a time, if their <code>queueRequest</code> parameters are
         * set to <code>"TRUE"</code>. The <code>dependencies</code> parameter lets you make execution of such a queued
         * request dependent on the successful completion of one or more specified previous requests in the queue.
         * </p>
         * <p>
         * For example, if load <code>Job-A</code> and <code>Job-B</code> are independent of each other, but load
         * <code>Job-C</code> needs <code>Job-A</code> and <code>Job-B</code> to be finished before it begins, proceed
         * as follows:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Submit <code>load-job-A</code> and <code>load-job-B</code> one after another in any order, and save their
         * load-ids.
         * </p>
         * </li>
         * <li>
         * <p>
         * Submit <code>load-job-C</code> with the load-ids of the two jobs in its <code>dependencies</code> field:
         * </p>
         * </li>
         * </ol>
         * <p>
         * Because of the <code>dependencies</code> parameter, the bulk loader will not start <code>Job-C</code> until
         * <code>Job-A</code> and <code>Job-B</code> have completed successfully. If either one of them fails, Job-C
         * will not be executed, and its status will be set to <code>LOAD_FAILED_BECAUSE_DEPENDENCY_NOT_SATISFIED</code>
         * .
         * </p>
         * <p>
         * You can set up multiple levels of dependency in this way, so that the failure of one job will cause all
         * requests that are directly or indirectly dependent on it to be cancelled.
         * </p>
         * 
         * @param dependencies
         *        This is an optional parameter that can make a queued load request contingent on the successful
         *        completion of one or more previous jobs in the queue.</p>
         *        <p>
         *        Neptune can queue up as many as 64 load requests at a time, if their <code>queueRequest</code>
         *        parameters are set to <code>"TRUE"</code>. The <code>dependencies</code> parameter lets you make
         *        execution of such a queued request dependent on the successful completion of one or more specified
         *        previous requests in the queue.
         *        </p>
         *        <p>
         *        For example, if load <code>Job-A</code> and <code>Job-B</code> are independent of each other, but load
         *        <code>Job-C</code> needs <code>Job-A</code> and <code>Job-B</code> to be finished before it begins,
         *        proceed as follows:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Submit <code>load-job-A</code> and <code>load-job-B</code> one after another in any order, and save
         *        their load-ids.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Submit <code>load-job-C</code> with the load-ids of the two jobs in its <code>dependencies</code>
         *        field:
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        Because of the <code>dependencies</code> parameter, the bulk loader will not start <code>Job-C</code>
         *        until <code>Job-A</code> and <code>Job-B</code> have completed successfully. If either one of them
         *        fails, Job-C will not be executed, and its status will be set to
         *        <code>LOAD_FAILED_BECAUSE_DEPENDENCY_NOT_SATISFIED</code>.
         *        </p>
         *        <p>
         *        You can set up multiple levels of dependency in this way, so that the failure of one job will cause
         *        all requests that are directly or indirectly dependent on it to be cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Collection<String> dependencies);

        /**
         * <p>
         * This is an optional parameter that can make a queued load request contingent on the successful completion of
         * one or more previous jobs in the queue.
         * </p>
         * <p>
         * Neptune can queue up as many as 64 load requests at a time, if their <code>queueRequest</code> parameters are
         * set to <code>"TRUE"</code>. The <code>dependencies</code> parameter lets you make execution of such a queued
         * request dependent on the successful completion of one or more specified previous requests in the queue.
         * </p>
         * <p>
         * For example, if load <code>Job-A</code> and <code>Job-B</code> are independent of each other, but load
         * <code>Job-C</code> needs <code>Job-A</code> and <code>Job-B</code> to be finished before it begins, proceed
         * as follows:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Submit <code>load-job-A</code> and <code>load-job-B</code> one after another in any order, and save their
         * load-ids.
         * </p>
         * </li>
         * <li>
         * <p>
         * Submit <code>load-job-C</code> with the load-ids of the two jobs in its <code>dependencies</code> field:
         * </p>
         * </li>
         * </ol>
         * <p>
         * Because of the <code>dependencies</code> parameter, the bulk loader will not start <code>Job-C</code> until
         * <code>Job-A</code> and <code>Job-B</code> have completed successfully. If either one of them fails, Job-C
         * will not be executed, and its status will be set to <code>LOAD_FAILED_BECAUSE_DEPENDENCY_NOT_SATISFIED</code>
         * .
         * </p>
         * <p>
         * You can set up multiple levels of dependency in this way, so that the failure of one job will cause all
         * requests that are directly or indirectly dependent on it to be cancelled.
         * </p>
         * 
         * @param dependencies
         *        This is an optional parameter that can make a queued load request contingent on the successful
         *        completion of one or more previous jobs in the queue.</p>
         *        <p>
         *        Neptune can queue up as many as 64 load requests at a time, if their <code>queueRequest</code>
         *        parameters are set to <code>"TRUE"</code>. The <code>dependencies</code> parameter lets you make
         *        execution of such a queued request dependent on the successful completion of one or more specified
         *        previous requests in the queue.
         *        </p>
         *        <p>
         *        For example, if load <code>Job-A</code> and <code>Job-B</code> are independent of each other, but load
         *        <code>Job-C</code> needs <code>Job-A</code> and <code>Job-B</code> to be finished before it begins,
         *        proceed as follows:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Submit <code>load-job-A</code> and <code>load-job-B</code> one after another in any order, and save
         *        their load-ids.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Submit <code>load-job-C</code> with the load-ids of the two jobs in its <code>dependencies</code>
         *        field:
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        Because of the <code>dependencies</code> parameter, the bulk loader will not start <code>Job-C</code>
         *        until <code>Job-A</code> and <code>Job-B</code> have completed successfully. If either one of them
         *        fails, Job-C will not be executed, and its status will be set to
         *        <code>LOAD_FAILED_BECAUSE_DEPENDENCY_NOT_SATISFIED</code>.
         *        </p>
         *        <p>
         *        You can set up multiple levels of dependency in this way, so that the failure of one job will cause
         *        all requests that are directly or indirectly dependent on it to be cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(String... dependencies);

        /**
         * <p>
         * This parameter is required only when loading openCypher data that contains relationship IDs. It must be
         * included and set to <code>True</code> when openCypher relationship IDs are explicitly provided in the load
         * data (recommended).
         * </p>
         * <p>
         * When <code>userProvidedEdgeIds</code> is absent or set to <code>True</code>, an <code>:ID</code> column must
         * be present in every relationship file in the load.
         * </p>
         * <p>
         * When <code>userProvidedEdgeIds</code> is present and set to <code>False</code>, relationship files in the
         * load <b>must not</b> contain an <code>:ID</code> column. Instead, the Neptune loader automatically generates
         * an ID for each relationship.
         * </p>
         * <p>
         * It's useful to provide relationship IDs explicitly so that the loader can resume loading after error in the
         * CSV data have been fixed, without having to reload any relationships that have already been loaded. If
         * relationship IDs have not been explicitly assigned, the loader cannot resume a failed load if any
         * relationship file has had to be corrected, and must instead reload all the relationships.
         * </p>
         * 
         * @param userProvidedEdgeIds
         *        This parameter is required only when loading openCypher data that contains relationship IDs. It must
         *        be included and set to <code>True</code> when openCypher relationship IDs are explicitly provided in
         *        the load data (recommended).</p>
         *        <p>
         *        When <code>userProvidedEdgeIds</code> is absent or set to <code>True</code>, an <code>:ID</code>
         *        column must be present in every relationship file in the load.
         *        </p>
         *        <p>
         *        When <code>userProvidedEdgeIds</code> is present and set to <code>False</code>, relationship files in
         *        the load <b>must not</b> contain an <code>:ID</code> column. Instead, the Neptune loader automatically
         *        generates an ID for each relationship.
         *        </p>
         *        <p>
         *        It's useful to provide relationship IDs explicitly so that the loader can resume loading after error
         *        in the CSV data have been fixed, without having to reload any relationships that have already been
         *        loaded. If relationship IDs have not been explicitly assigned, the loader cannot resume a failed load
         *        if any relationship file has had to be corrected, and must instead reload all the relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProvidedEdgeIds(Boolean userProvidedEdgeIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String source;

        private String format;

        private String s3BucketRegion;

        private String iamRoleArn;

        private String mode;

        private Boolean failOnError;

        private String parallelism;

        private Map<String, String> parserConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private Boolean updateSingleCardinalityProperties;

        private Boolean queueRequest;

        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();

        private Boolean userProvidedEdgeIds;

        private BuilderImpl() {
        }

        private BuilderImpl(StartLoaderJobRequest model) {
            super(model);
            source(model.source);
            format(model.format);
            s3BucketRegion(model.s3BucketRegion);
            iamRoleArn(model.iamRoleArn);
            mode(model.mode);
            failOnError(model.failOnError);
            parallelism(model.parallelism);
            parserConfiguration(model.parserConfiguration);
            updateSingleCardinalityProperties(model.updateSingleCardinalityProperties);
            queueRequest(model.queueRequest);
            dependencies(model.dependencies);
            userProvidedEdgeIds(model.userProvidedEdgeIds);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getS3BucketRegion() {
            return s3BucketRegion;
        }

        public final void setS3BucketRegion(String s3BucketRegion) {
            this.s3BucketRegion = s3BucketRegion;
        }

        @Override
        public final Builder s3BucketRegion(String s3BucketRegion) {
            this.s3BucketRegion = s3BucketRegion;
            return this;
        }

        @Override
        public final Builder s3BucketRegion(S3BucketRegion s3BucketRegion) {
            this.s3BucketRegion(s3BucketRegion == null ? null : s3BucketRegion.toString());
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Boolean getFailOnError() {
            return failOnError;
        }

        public final void setFailOnError(Boolean failOnError) {
            this.failOnError = failOnError;
        }

        @Override
        public final Builder failOnError(Boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public final String getParallelism() {
            return parallelism;
        }

        public final void setParallelism(String parallelism) {
            this.parallelism = parallelism;
        }

        @Override
        public final Builder parallelism(String parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        @Override
        public final Builder parallelism(Parallelism parallelism) {
            this.parallelism(parallelism == null ? null : parallelism.toString());
            return this;
        }

        public final Map<String, String> getParserConfiguration() {
            if (parserConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return parserConfiguration;
        }

        public final void setParserConfiguration(Map<String, String> parserConfiguration) {
            this.parserConfiguration = StringValuedMapCopier.copy(parserConfiguration);
        }

        @Override
        public final Builder parserConfiguration(Map<String, String> parserConfiguration) {
            this.parserConfiguration = StringValuedMapCopier.copy(parserConfiguration);
            return this;
        }

        public final Boolean getUpdateSingleCardinalityProperties() {
            return updateSingleCardinalityProperties;
        }

        public final void setUpdateSingleCardinalityProperties(Boolean updateSingleCardinalityProperties) {
            this.updateSingleCardinalityProperties = updateSingleCardinalityProperties;
        }

        @Override
        public final Builder updateSingleCardinalityProperties(Boolean updateSingleCardinalityProperties) {
            this.updateSingleCardinalityProperties = updateSingleCardinalityProperties;
            return this;
        }

        public final Boolean getQueueRequest() {
            return queueRequest;
        }

        public final void setQueueRequest(Boolean queueRequest) {
            this.queueRequest = queueRequest;
        }

        @Override
        public final Builder queueRequest(Boolean queueRequest) {
            this.queueRequest = queueRequest;
            return this;
        }

        public final Collection<String> getDependencies() {
            if (dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = StringListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = StringListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String... dependencies) {
            dependencies(Arrays.asList(dependencies));
            return this;
        }

        public final Boolean getUserProvidedEdgeIds() {
            return userProvidedEdgeIds;
        }

        public final void setUserProvidedEdgeIds(Boolean userProvidedEdgeIds) {
            this.userProvidedEdgeIds = userProvidedEdgeIds;
        }

        @Override
        public final Builder userProvidedEdgeIds(Boolean userProvidedEdgeIds) {
            this.userProvidedEdgeIds = userProvidedEdgeIds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartLoaderJobRequest build() {
            return new StartLoaderJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
