/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMlModelTrainingJobResponse extends NeptunedataResponse implements
        ToCopyableBuilder<StartMlModelTrainingJobResponse.Builder, StartMlModelTrainingJobResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(StartMlModelTrainingJobResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(StartMlModelTrainingJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Long> CREATION_TIME_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("creationTimeInMillis").getter(getter(StartMlModelTrainingJobResponse::creationTimeInMillis))
            .setter(setter(Builder::creationTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimeInMillis").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            CREATION_TIME_IN_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final Long creationTimeInMillis;

    private StartMlModelTrainingJobResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.creationTimeInMillis = builder.creationTimeInMillis;
    }

    /**
     * <p>
     * The unique ID of the new model training job.
     * </p>
     * 
     * @return The unique ID of the new model training job.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the new model training job.
     * </p>
     * 
     * @return The ARN of the new model training job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The model training job creation time, in milliseconds.
     * </p>
     * 
     * @return The model training job creation time, in milliseconds.
     */
    public final Long creationTimeInMillis() {
        return creationTimeInMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeInMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlModelTrainingJobResponse)) {
            return false;
        }
        StartMlModelTrainingJobResponse other = (StartMlModelTrainingJobResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(creationTimeInMillis(), other.creationTimeInMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMlModelTrainingJobResponse").add("Id", id()).add("Arn", arn())
                .add("CreationTimeInMillis", creationTimeInMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationTimeInMillis":
            return Optional.ofNullable(clazz.cast(creationTimeInMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("creationTimeInMillis", CREATION_TIME_IN_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMlModelTrainingJobResponse, T> g) {
        return obj -> g.apply((StartMlModelTrainingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMlModelTrainingJobResponse> {
        /**
         * <p>
         * The unique ID of the new model training job.
         * </p>
         * 
         * @param id
         *        The unique ID of the new model training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the new model training job.
         * </p>
         * 
         * @param arn
         *        The ARN of the new model training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The model training job creation time, in milliseconds.
         * </p>
         * 
         * @param creationTimeInMillis
         *        The model training job creation time, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeInMillis(Long creationTimeInMillis);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private Long creationTimeInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlModelTrainingJobResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            creationTimeInMillis(model.creationTimeInMillis);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getCreationTimeInMillis() {
            return creationTimeInMillis;
        }

        public final void setCreationTimeInMillis(Long creationTimeInMillis) {
            this.creationTimeInMillis = creationTimeInMillis;
        }

        @Override
        public final Builder creationTimeInMillis(Long creationTimeInMillis) {
            this.creationTimeInMillis = creationTimeInMillis;
            return this;
        }

        @Override
        public StartMlModelTrainingJobResponse build() {
            return new StartMlModelTrainingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
