/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.GremlinQueryStatus;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataResponse;
import software.amazon.awssdk.services.neptunedata.model.OpenCypherQueriesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOpenCypherQueriesResponse
extends NeptunedataResponse
implements ToCopyableBuilder<Builder, ListOpenCypherQueriesResponse> {
    private static final SdkField<Integer> ACCEPTED_QUERY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("acceptedQueryCount").getter(ListOpenCypherQueriesResponse.getter(ListOpenCypherQueriesResponse::acceptedQueryCount)).setter(ListOpenCypherQueriesResponse.setter(Builder::acceptedQueryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedQueryCount").build()}).build();
    private static final SdkField<Integer> RUNNING_QUERY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("runningQueryCount").getter(ListOpenCypherQueriesResponse.getter(ListOpenCypherQueriesResponse::runningQueryCount)).setter(ListOpenCypherQueriesResponse.setter(Builder::runningQueryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningQueryCount").build()}).build();
    private static final SdkField<List<GremlinQueryStatus>> QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queries").getter(ListOpenCypherQueriesResponse.getter(ListOpenCypherQueriesResponse::queries)).setter(ListOpenCypherQueriesResponse.setter(Builder::queries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GremlinQueryStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTED_QUERY_COUNT_FIELD, RUNNING_QUERY_COUNT_FIELD, QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOpenCypherQueriesResponse.memberNameToFieldInitializer();
    private final Integer acceptedQueryCount;
    private final Integer runningQueryCount;
    private final List<GremlinQueryStatus> queries;

    private ListOpenCypherQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.acceptedQueryCount = builder.acceptedQueryCount;
        this.runningQueryCount = builder.runningQueryCount;
        this.queries = builder.queries;
    }

    public final Integer acceptedQueryCount() {
        return this.acceptedQueryCount;
    }

    public final Integer runningQueryCount() {
        return this.runningQueryCount;
    }

    public final boolean hasQueries() {
        return this.queries != null && !(this.queries instanceof SdkAutoConstructList);
    }

    public final List<GremlinQueryStatus> queries() {
        return this.queries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptedQueryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningQueryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueries() ? this.queries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpenCypherQueriesResponse)) {
            return false;
        }
        ListOpenCypherQueriesResponse other = (ListOpenCypherQueriesResponse)((Object)obj);
        return Objects.equals(this.acceptedQueryCount(), other.acceptedQueryCount()) && Objects.equals(this.runningQueryCount(), other.runningQueryCount()) && this.hasQueries() == other.hasQueries() && Objects.equals(this.queries(), other.queries());
    }

    public final String toString() {
        return ToString.builder((String)"ListOpenCypherQueriesResponse").add("AcceptedQueryCount", (Object)this.acceptedQueryCount()).add("RunningQueryCount", (Object)this.runningQueryCount()).add("Queries", this.hasQueries() ? this.queries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceptedQueryCount": {
                return Optional.ofNullable(clazz.cast(this.acceptedQueryCount()));
            }
            case "runningQueryCount": {
                return Optional.ofNullable(clazz.cast(this.runningQueryCount()));
            }
            case "queries": {
                return Optional.ofNullable(clazz.cast(this.queries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("acceptedQueryCount", ACCEPTED_QUERY_COUNT_FIELD);
        map.put("runningQueryCount", RUNNING_QUERY_COUNT_FIELD);
        map.put("queries", QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOpenCypherQueriesResponse, T> g) {
        return obj -> g.apply((ListOpenCypherQueriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataResponse.BuilderImpl
    implements Builder {
        private Integer acceptedQueryCount;
        private Integer runningQueryCount;
        private List<GremlinQueryStatus> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpenCypherQueriesResponse model) {
            super(model);
            this.acceptedQueryCount(model.acceptedQueryCount);
            this.runningQueryCount(model.runningQueryCount);
            this.queries(model.queries);
        }

        public final Integer getAcceptedQueryCount() {
            return this.acceptedQueryCount;
        }

        public final void setAcceptedQueryCount(Integer acceptedQueryCount) {
            this.acceptedQueryCount = acceptedQueryCount;
        }

        @Override
        public final Builder acceptedQueryCount(Integer acceptedQueryCount) {
            this.acceptedQueryCount = acceptedQueryCount;
            return this;
        }

        public final Integer getRunningQueryCount() {
            return this.runningQueryCount;
        }

        public final void setRunningQueryCount(Integer runningQueryCount) {
            this.runningQueryCount = runningQueryCount;
        }

        @Override
        public final Builder runningQueryCount(Integer runningQueryCount) {
            this.runningQueryCount = runningQueryCount;
            return this;
        }

        public final List<GremlinQueryStatus.Builder> getQueries() {
            List<GremlinQueryStatus.Builder> result = OpenCypherQueriesCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<GremlinQueryStatus.BuilderImpl> queries) {
            this.queries = OpenCypherQueriesCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<GremlinQueryStatus> queries) {
            this.queries = OpenCypherQueriesCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(GremlinQueryStatus ... queries) {
            this.queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<GremlinQueryStatus.Builder> ... queries) {
            this.queries(Stream.of(queries).map(c -> (GremlinQueryStatus)((GremlinQueryStatus.Builder)GremlinQueryStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOpenCypherQueriesResponse build() {
            return new ListOpenCypherQueriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOpenCypherQueriesResponse> {
        public Builder acceptedQueryCount(Integer var1);

        public Builder runningQueryCount(Integer var1);

        public Builder queries(Collection<GremlinQueryStatus> var1);

        public Builder queries(GremlinQueryStatus ... var1);

        public Builder queries(Consumer<GremlinQueryStatus.Builder> ... var1);
    }
}

