/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.ParticipantRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelDefinition> {
    private static final SdkField<Integer> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChannelId").getter(ChannelDefinition.getter(ChannelDefinition::channelId)).setter(ChannelDefinition.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()}).build();
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantRole").getter(ChannelDefinition.getter(ChannelDefinition::participantRoleAsString)).setter(ChannelDefinition.setter(Builder::participantRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, PARTICIPANT_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChannelDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer channelId;
    private final String participantRole;

    private ChannelDefinition(BuilderImpl builder) {
        this.channelId = builder.channelId;
        this.participantRole = builder.participantRole;
    }

    public final Integer channelId() {
        return this.channelId;
    }

    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(this.participantRole);
    }

    public final String participantRoleAsString() {
        return this.participantRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantRoleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelDefinition)) {
            return false;
        }
        ChannelDefinition other = (ChannelDefinition)obj;
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.participantRoleAsString(), other.participantRoleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelDefinition").add("ChannelId", (Object)this.channelId()).add("ParticipantRole", (Object)this.participantRoleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "ParticipantRole": {
                return Optional.ofNullable(clazz.cast(this.participantRoleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelId", CHANNEL_ID_FIELD);
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelDefinition, T> g) {
        return obj -> g.apply((ChannelDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer channelId;
        private String participantRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelDefinition model) {
            this.channelId(model.channelId);
            this.participantRole(model.participantRole);
        }

        public final Integer getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(Integer channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(Integer channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getParticipantRole() {
            return this.participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public ChannelDefinition build() {
            return new ChannelDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelDefinition> {
        public Builder channelId(Integer var1);

        public Builder participantRole(String var1);

        public Builder participantRole(ParticipantRole var1);
    }
}

