/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;

final class CachedIntrospectionResults {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$CachedIntrospectionResults == null ? (class$org$springframework$beans$CachedIntrospectionResults = CachedIntrospectionResults.class$("org.springframework.beans.CachedIntrospectionResults")) : class$org$springframework$beans$CachedIntrospectionResults));
    private static final Map classCache = Collections.synchronizedMap(new WeakHashMap());
    private final BeanInfo beanInfo;
    private final Map propertyDescriptorCache;
    static /* synthetic */ Class class$org$springframework$beans$CachedIntrospectionResults;

    static CachedIntrospectionResults forClass(Class clazz) throws BeansException {
        CachedIntrospectionResults results = null;
        Object value = classCache.get(clazz);
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            results = (CachedIntrospectionResults)ref.get();
        } else {
            results = (CachedIntrospectionResults)value;
        }
        if (results == null) {
            results = new CachedIntrospectionResults(clazz);
            boolean cacheSafe = CachedIntrospectionResults.isCacheSafe(clazz);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Class [" + clazz.getName() + "] is " + (!cacheSafe ? "not " : "") + "cache-safe"));
            }
            if (cacheSafe) {
                classCache.put(clazz, results);
            } else {
                classCache.put(clazz, new WeakReference<CachedIntrospectionResults>(results));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using cached introspection results for class [" + clazz.getName() + "]"));
        }
        return results;
    }

    private static boolean isCacheSafe(Class clazz) {
        ClassLoader cur = (class$org$springframework$beans$CachedIntrospectionResults == null ? (class$org$springframework$beans$CachedIntrospectionResults = CachedIntrospectionResults.class$("org.springframework.beans.CachedIntrospectionResults")) : class$org$springframework$beans$CachedIntrospectionResults).getClassLoader();
        ClassLoader target = clazz.getClassLoader();
        if (target == null || cur == target) {
            return true;
        }
        while (cur != null) {
            if ((cur = cur.getParent()) != target) continue;
            return true;
        }
        return false;
    }

    private CachedIntrospectionResults(Class clazz) throws BeansException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting BeanInfo for class [" + clazz.getName() + "]"));
            }
            this.beanInfo = Introspector.getBeanInfo(clazz);
            Class classToFlush = clazz;
            do {
                Introspector.flushFromCaches(classToFlush);
            } while ((classToFlush = classToFlush.getSuperclass()) != null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caching PropertyDescriptors for class [" + clazz.getName() + "]"));
            }
            this.propertyDescriptorCache = new HashMap();
            PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found property '" + pds[i].getName() + "' of type [" + pds[i].getPropertyType() + "]; editor=[" + pds[i].getPropertyEditorClass() + "]"));
                }
                this.propertyDescriptorCache.put(pds[i].getName(), pds[i]);
            }
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Cannot get BeanInfo for object of class [" + clazz.getName() + "]", ex);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return (PropertyDescriptor)this.propertyDescriptorCache.get(propertyName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

