/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.springframework.core.ControlFlow;
import org.springframework.core.JdkVersion;

public abstract class ControlFlowFactory {
    public static ControlFlow createControlFlow() {
        return JdkVersion.getMajorJavaVersion() >= 1 ? new Jdk14ControlFlow() : new Jdk13ControlFlow();
    }

    static class Jdk13ControlFlow
    implements ControlFlow {
        private String stackTrace;

        public Jdk13ControlFlow() {
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            this.stackTrace = sw.toString();
        }

        public boolean under(Class clazz) {
            return this.stackTrace.indexOf(clazz.getName()) != -1;
        }

        public boolean under(Class clazz, String methodName) {
            return this.stackTrace.indexOf(clazz.getName() + "." + methodName + "(") != -1;
        }

        public boolean underToken(String token) {
            return this.stackTrace.indexOf(token) != -1;
        }
    }

    static class Jdk14ControlFlow
    implements ControlFlow {
        private StackTraceElement[] stack = new Throwable().getStackTrace();

        public boolean under(Class clazz) {
            String className = clazz.getName();
            for (int i = 0; i < this.stack.length; ++i) {
                if (!this.stack[i].getClassName().equals(className)) continue;
                return true;
            }
            return false;
        }

        public boolean under(Class clazz, String methodName) {
            String className = clazz.getName();
            for (int i = 0; i < this.stack.length; ++i) {
                if (!this.stack[i].getClassName().equals(className) || !this.stack[i].getMethodName().equals(methodName)) continue;
                return true;
            }
            return false;
        }

        public boolean underToken(String token) {
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            return stackTrace.indexOf(token) != -1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Jdk14ControlFlow: ");
            for (int i = 0; i < this.stack.length; ++i) {
                if (i > 0) {
                    sb.append("\n\t@");
                }
                sb.append(this.stack[i]);
            }
            return sb.toString();
        }
    }
}

