/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;

public class StopWatch {
    private long startTime;
    private long runningTime;
    private List taskList = new LinkedList();
    private String currentTask;
    private boolean running;
    private String id = "";
    private boolean keepTaskList = true;
    private TaskInfo lastTaskInfo;
    private int taskCount;

    public StopWatch() {
    }

    public StopWatch(String id) {
        this.id = id;
    }

    public void setKeepTaskList(boolean keepTaskList) {
        this.keepTaskList = keepTaskList;
    }

    public boolean getKeepTaskList() {
        return this.keepTaskList;
    }

    public void start(String task) throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("Can't start StopWatch: it's already running");
        }
        this.startTime = System.currentTimeMillis();
        this.currentTask = task;
        this.running = true;
    }

    public void stop() throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long lastTime = System.currentTimeMillis() - this.startTime;
        this.runningTime += lastTime;
        this.lastTaskInfo = new TaskInfo(this.currentTask, lastTime);
        if (this.keepTaskList) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.running = false;
        this.currentTask = null;
    }

    public long getTotalTime() {
        return this.runningTime;
    }

    public long getLastInterval() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tests run: can't get last interval");
        }
        return this.lastTaskInfo.getTime();
    }

    public double getTotalTimeSecs() {
        return (double)this.runningTime / 1000.0;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public TaskInfo[] getTaskInfo() {
        if (!this.keepTaskList) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskList.toArray(new TaskInfo[0]);
    }

    public boolean isRunning() {
        return this.running;
    }

    public String shortSummary() {
        return "StopWatch '" + this.id + "': running time (secs) = " + this.getTotalTimeSecs() + "\n";
    }

    public String prettyPrint() {
        StringBuffer sb = new StringBuffer(this.shortSummary());
        if (!this.keepTaskList) {
            sb.append("No task info kept");
        } else {
            TaskInfo[] tasks = this.getTaskInfo();
            sb.append("-----------------------------------------\n");
            sb.append("ms     %     Task name\n");
            sb.append("-----------------------------------------\n");
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(5);
            nf.setGroupingUsed(false);
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMinimumIntegerDigits(3);
            pf.setGroupingUsed(false);
            for (int i = 0; i < tasks.length; ++i) {
                sb.append(nf.format(tasks[i].getTime()) + "  ");
                sb.append(pf.format(tasks[i].getTimeSecs() / this.getTotalTimeSecs()) + "  ");
                sb.append(tasks[i].getTaskName() + "\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.shortSummary());
        if (this.keepTaskList) {
            TaskInfo[] tasks = this.getTaskInfo();
            for (int i = 0; i < tasks.length; ++i) {
                if (i > 0) {
                    sb.append("; ");
                }
                sb.append("[" + tasks[i].getTaskName() + "] took " + tasks[i].getTimeSecs());
                long percent = Math.round(100.0 * tasks[i].getTimeSecs() / this.getTotalTimeSecs());
                sb.append("=" + percent + "%");
            }
        } else {
            sb.append("Not keeping task info");
        }
        return sb.toString();
    }

    public static class TaskInfo {
        private String task;
        private long time;

        private TaskInfo(String task, long time) {
            this.task = task;
            this.time = time;
        }

        public String getTaskName() {
            return this.task;
        }

        public long getTime() {
            return this.time;
        }

        public double getTimeSecs() {
            return (double)this.time / 1000.0;
        }
    }
}

