/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.compat.SpyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KetamaIterator
extends SpyObject
implements Iterator<MemcachedNode> {
    final String key;
    long hashVal;
    int remainingTries;
    int numTries = 0;
    final HashAlgorithm hashAlg;
    final TreeMap<Long, MemcachedNode> ketamaNodes;

    protected KetamaIterator(String k, int t, TreeMap<Long, MemcachedNode> ketamaNodes, HashAlgorithm hashAlg) {
        this.ketamaNodes = ketamaNodes;
        this.hashAlg = hashAlg;
        this.hashVal = hashAlg.hash(k);
        this.remainingTries = t;
        this.key = k;
    }

    private void nextHash() {
        long tmpKey = this.hashAlg.hash(this.numTries++ + this.key);
        this.hashVal += (long)((int)(tmpKey ^ tmpKey >>> 32));
        this.hashVal &= 0xFFFFFFFFL;
        --this.remainingTries;
    }

    @Override
    public boolean hasNext() {
        return this.remainingTries > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemcachedNode next() {
        try {
            MemcachedNode memcachedNode = this.getNodeForKey(this.hashVal);
            return memcachedNode;
        }
        finally {
            this.nextHash();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    private MemcachedNode getNodeForKey(long hash) {
        if (!this.ketamaNodes.containsKey(hash)) {
            SortedMap<Long, MemcachedNode> tailMap = this.ketamaNodes.tailMap(hash);
            hash = tailMap.isEmpty() ? this.ketamaNodes.firstKey().longValue() : tailMap.firstKey().longValue();
        }
        MemcachedNode rv = this.ketamaNodes.get(hash);
        return rv;
    }
}

