/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.protocol.ascii.AsciiMemcachedNodeImpl;
import net.spy.memcached.protocol.ascii.AsciiOperationFactory;
import net.spy.memcached.protocol.binary.BinaryMemcachedNodeImpl;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConnectionFactory
extends SpyObject
implements ConnectionFactory {
    public static final FailureMode DEFAULT_FAILURE_MODE = FailureMode.Redistribute;
    public static final HashAlgorithm DEFAULT_HASH = HashAlgorithm.NATIVE_HASH;
    public static final int DEFAULT_OP_QUEUE_LEN = 16384;
    public static final long DEFAULT_OP_QUEUE_MAX_BLOCK_TIME = TimeUnit.SECONDS.toMillis(10L);
    public static final int DEFAULT_READ_BUFFER_SIZE = 16384;
    public static final long DEFAULT_OPERATION_TIMEOUT = 2500L;
    public static final long DEFAULT_MAX_RECONNECT_DELAY = 30L;
    public static final int DEFAULT_MAX_TIMEOUTEXCEPTION_THRESHOLD = 998;
    protected final int opQueueLen;
    private final int readBufSize;
    private final HashAlgorithm hashAlg;

    public DefaultConnectionFactory(int qLen, int bufSize, HashAlgorithm hash) {
        this.opQueueLen = qLen;
        this.readBufSize = bufSize;
        this.hashAlg = hash;
    }

    public DefaultConnectionFactory(int qLen, int bufSize) {
        this(qLen, bufSize, DEFAULT_HASH);
    }

    public DefaultConnectionFactory() {
        this(16384, 16384);
    }

    @Override
    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        OperationFactory of = this.getOperationFactory();
        if (of instanceof AsciiOperationFactory) {
            return new AsciiMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), this.getOpQueueMaxBlockTime(), this.getOperationTimeout());
        }
        if (of instanceof BinaryOperationFactory) {
            boolean doAuth = false;
            if (this.getAuthDescriptor() != null) {
                doAuth = true;
            }
            return new BinaryMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), (Long)this.getOpQueueMaxBlockTime(), doAuth, this.getOperationTimeout());
        }
        throw new IllegalStateException("Unhandled operation factory type " + of);
    }

    @Override
    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        return new MemcachedConnection(this.getReadBufSize(), this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
    }

    @Override
    public FailureMode getFailureMode() {
        return DEFAULT_FAILURE_MODE;
    }

    @Override
    public BlockingQueue<Operation> createOperationQueue() {
        return new ArrayBlockingQueue<Operation>(this.getOpQueueLen());
    }

    @Override
    public BlockingQueue<Operation> createReadOperationQueue() {
        return new LinkedBlockingQueue<Operation>();
    }

    @Override
    public BlockingQueue<Operation> createWriteOperationQueue() {
        return new LinkedBlockingQueue<Operation>();
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return new ArrayModNodeLocator(nodes, this.getHashAlg());
    }

    public int getOpQueueLen() {
        return this.opQueueLen;
    }

    @Override
    public long getOpQueueMaxBlockTime() {
        return DEFAULT_OP_QUEUE_MAX_BLOCK_TIME;
    }

    @Override
    public int getReadBufSize() {
        return this.readBufSize;
    }

    @Override
    public HashAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    @Override
    public OperationFactory getOperationFactory() {
        return new AsciiOperationFactory();
    }

    @Override
    public long getOperationTimeout() {
        return 2500L;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public Collection<ConnectionObserver> getInitialObservers() {
        return Collections.emptyList();
    }

    @Override
    public Transcoder<Object> getDefaultTranscoder() {
        return new SerializingTranscoder();
    }

    @Override
    public boolean useNagleAlgorithm() {
        return false;
    }

    @Override
    public boolean shouldOptimize() {
        return true;
    }

    @Override
    public long getMaxReconnectDelay() {
        return 30L;
    }

    @Override
    public AuthDescriptor getAuthDescriptor() {
        return null;
    }

    @Override
    public int getTimeoutExceptionThreshold() {
        return 998;
    }
}

