/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.naming.ConfigurationException;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.AuthThreadMonitor;
import net.spy.memcached.auth.PlainCallbackHandler;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.transcoders.TranscodeService;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.vbucket.ConfigurationProvider;
import net.spy.memcached.vbucket.ConfigurationProviderHTTP;
import net.spy.memcached.vbucket.Reconfigurable;
import net.spy.memcached.vbucket.config.Bucket;
import net.spy.memcached.vbucket.config.Config;
import net.spy.memcached.vbucket.config.ConfigType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TapConnectionProvider
extends SpyObject
implements ConnectionObserver,
Reconfigurable {
    private volatile boolean shuttingDown = false;
    private final MemcachedConnection conn;
    final OperationFactory opFact;
    final Transcoder<Object> transcoder;
    final TranscodeService tcService;
    final AuthDescriptor authDescriptor;
    private final AuthThreadMonitor authMonitor = new AuthThreadMonitor();
    private ConfigurationProvider configurationProvider;

    public TapConnectionProvider(InetSocketAddress ... ia) throws IOException {
        this(new BinaryConnectionFactory(), Arrays.asList(ia));
    }

    public TapConnectionProvider(List<InetSocketAddress> addrs) throws IOException {
        this(new BinaryConnectionFactory(), addrs);
    }

    private TapConnectionProvider(ConnectionFactory cf, List<InetSocketAddress> addrs) throws IOException {
        if (cf == null) {
            throw new NullPointerException("Connection factory required");
        }
        if (addrs == null) {
            throw new NullPointerException("Server list required");
        }
        if (addrs.isEmpty()) {
            throw new IllegalArgumentException("You must have at least one server to connect to");
        }
        if (cf.getOperationTimeout() <= 0L) {
            throw new IllegalArgumentException("Operation timeout must be positive.");
        }
        this.tcService = new TranscodeService(cf.isDaemon());
        this.transcoder = cf.getDefaultTranscoder();
        this.opFact = cf.getOperationFactory();
        assert (this.opFact != null) : "Connection factory failed to make op factory";
        this.conn = cf.createConnection(addrs);
        assert (this.conn != null) : "Connection factory failed to make a connection";
        this.authDescriptor = cf.getAuthDescriptor();
        if (this.authDescriptor != null) {
            this.addObserver(this);
        }
    }

    public TapConnectionProvider(List<URI> baseList, String bucketName, String usr, String pwd) throws IOException, ConfigurationException {
        for (URI bu : baseList) {
            if (bu.isAbsolute()) continue;
            throw new IllegalArgumentException("The base URI must be absolute");
        }
        this.configurationProvider = new ConfigurationProviderHTTP(baseList, usr, pwd);
        Bucket bucket = this.configurationProvider.getBucketConfiguration(bucketName);
        Config config = bucket.getConfig();
        ConnectionFactoryBuilder cfb = new ConnectionFactoryBuilder();
        if (config.getConfigType() == ConfigType.MEMBASE) {
            cfb.setFailureMode(FailureMode.Retry).setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setHashAlg(HashAlgorithm.KETAMA_HASH).setLocatorType(ConnectionFactoryBuilder.Locator.VBUCKET).setVBucketConfig(bucket.getConfig());
        } else if (config.getConfigType() == ConfigType.MEMCACHE) {
            cfb.setFailureMode(FailureMode.Redistribute).setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setHashAlg(HashAlgorithm.KETAMA_HASH).setLocatorType(ConnectionFactoryBuilder.Locator.CONSISTENT).setShouldOptimize(false);
        } else {
            throw new ConfigurationException("Bucket type not supported or JSON response unexpected");
        }
        if (!this.configurationProvider.getAnonymousAuthBucket().equals(bucketName) && usr != null) {
            AuthDescriptor ad = new AuthDescriptor(new String[]{"PLAIN"}, new PlainCallbackHandler(usr, pwd));
            cfb.setAuthDescriptor(ad);
        }
        ConnectionFactory cf = cfb.build();
        List<InetSocketAddress> addrs = AddrUtil.getAddresses(bucket.getConfig().getServers());
        if (cf == null) {
            throw new NullPointerException("Connection factory required");
        }
        if (addrs == null) {
            throw new NullPointerException("Server list required");
        }
        if (addrs.isEmpty()) {
            throw new IllegalArgumentException("You must have at least one server to connect to");
        }
        if (cf.getOperationTimeout() <= 0L) {
            throw new IllegalArgumentException("Operation timeout must be positive.");
        }
        this.tcService = new TranscodeService(cf.isDaemon());
        this.transcoder = cf.getDefaultTranscoder();
        this.opFact = cf.getOperationFactory();
        assert (this.opFact != null) : "Connection factory failed to make op factory";
        this.conn = cf.createConnection(addrs);
        assert (this.conn != null) : "Connection factory failed to make a connection";
        this.authDescriptor = cf.getAuthDescriptor();
        if (this.authDescriptor != null) {
            this.addObserver(this);
        }
        this.configurationProvider.subscribe(bucketName, this);
    }

    Operation addOp(Operation op) {
        this.conn.checkState();
        this.conn.addOperation("", op);
        return op;
    }

    public boolean addObserver(ConnectionObserver obs) {
        boolean rv = this.conn.addObserver(obs);
        if (rv) {
            for (MemcachedNode node : this.conn.getLocator().getAll()) {
                if (!node.isActive()) continue;
                obs.connectionEstablished(node.getSocketAddress(), -1);
            }
        }
        return rv;
    }

    public boolean removeObserver(ConnectionObserver obs) {
        return this.conn.removeObserver(obs);
    }

    @Override
    public void connectionEstablished(SocketAddress sa, int reconnectCount) {
        if (this.authDescriptor != null) {
            if (this.authDescriptor.authThresholdReached()) {
                this.shutdown();
            } else {
                this.authMonitor.authConnection(this.conn, this.opFact, this.authDescriptor, this.findNode(sa));
            }
        }
    }

    private MemcachedNode findNode(SocketAddress sa) {
        MemcachedNode node = null;
        for (MemcachedNode n : this.conn.getLocator().getAll()) {
            if (!n.getSocketAddress().equals(sa)) continue;
            node = n;
        }
        assert (node != null) : "Couldn't find node connected to " + sa;
        return node;
    }

    @Override
    public void connectionLost(SocketAddress sa) {
    }

    @Override
    public void reconfigure(Bucket bucket) {
        this.conn.reconfigure(bucket);
    }

    public void shutdown() {
        this.shutdown(-1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(long timeout, TimeUnit unit) {
        if (this.shuttingDown) {
            this.getLogger().info("Suppressing duplicate attempt to shut down");
            return false;
        }
        this.shuttingDown = true;
        String baseName = this.conn.getName();
        this.conn.setName(baseName + " - SHUTTING DOWN");
        boolean rv = false;
        try {
            if (timeout > 0L) {
                this.conn.setName(baseName + " - SHUTTING DOWN (waiting)");
                rv = this.waitForQueues(timeout, unit);
            }
        }
        finally {
            try {
                this.conn.setName(baseName + " - SHUTTING DOWN (telling client)");
                this.conn.shutdown();
                this.conn.setName(baseName + " - SHUTTING DOWN (informed client)");
                this.tcService.shutdown();
                if (this.configurationProvider != null) {
                    this.configurationProvider.shutdown();
                }
            }
            catch (IOException e) {
                this.getLogger().warn((Object)"exception while shutting down", e);
            }
        }
        return rv;
    }

    public boolean waitForQueues(long timeout, TimeUnit unit) {
        CountDownLatch blatch = this.broadcastOp(new BroadcastOpFactory(){

            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                return TapConnectionProvider.this.opFact.noop(new OperationCallback(){

                    public void complete() {
                        latch.countDown();
                    }

                    public void receivedStatus(OperationStatus s) {
                    }
                });
            }
        }, this.conn.getLocator().getAll(), false);
        try {
            return blatch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for queues", e);
        }
    }

    CountDownLatch broadcastOp(BroadcastOpFactory of) {
        return this.broadcastOp(of, this.conn.getLocator().getAll(), true);
    }

    CountDownLatch broadcastOp(BroadcastOpFactory of, Collection<MemcachedNode> nodes) {
        return this.broadcastOp(of, nodes, true);
    }

    private CountDownLatch broadcastOp(BroadcastOpFactory of, Collection<MemcachedNode> nodes, boolean checkShuttingDown) {
        if (checkShuttingDown && this.shuttingDown) {
            throw new IllegalStateException("Shutting down");
        }
        return this.conn.broadcastOperation(of, nodes);
    }
}

