/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.couch;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.couch.AsyncConnectionRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.HttpParams;

public class AsyncConnectionManager
extends SpyObject {
    private final HttpHost target;
    private final int maxConnections;
    private final NHttpClientHandler handler;
    private final HttpParams params;
    private final ConnectingIOReactor ioreactor;
    private final Object lock;
    private final Set<NHttpClientConnection> allConns;
    private final Queue<NHttpClientConnection> availableConns;
    private final Queue<AsyncConnectionRequest> pendingRequests;
    private volatile boolean shutdown;

    public AsyncConnectionManager(HttpHost target, int maxConnections, NHttpClientHandler handler, HttpParams params) throws IOReactorException {
        this.target = target;
        this.maxConnections = maxConnections;
        this.handler = handler;
        this.params = params;
        this.lock = new Object();
        this.allConns = new HashSet<NHttpClientConnection>();
        this.availableConns = new LinkedList<NHttpClientConnection>();
        this.pendingRequests = new LinkedList<AsyncConnectionRequest>();
        this.ioreactor = new DefaultConnectingIOReactor(2, params);
    }

    public void execute() throws IOException {
        DefaultClientIOEventDispatch dispatch = new DefaultClientIOEventDispatch((NHttpClientHandler)new ManagedClientHandler(this.handler, this), this.params);
        this.ioreactor.execute((IOEventDispatch)dispatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(long waitMs) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                while (!this.pendingRequests.isEmpty()) {
                    AsyncConnectionRequest request = this.pendingRequests.remove();
                    request.cancel();
                }
                this.availableConns.clear();
                this.allConns.clear();
            }
        }
        this.ioreactor.shutdown(waitMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(NHttpClientConnection conn) {
        if (conn == null) {
            return;
        }
        if (this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.allConns.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(NHttpClientConnection conn) {
        if (conn == null) {
            return;
        }
        if (this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.allConns.remove(conn)) {
                this.availableConns.remove(conn);
            }
            this.processConnectionRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncConnectionRequest requestConnection() {
        if (this.shutdown) {
            throw new IllegalStateException("Connection manager has been shut down");
        }
        AsyncConnectionRequest request = new AsyncConnectionRequest();
        Object object = this.lock;
        synchronized (object) {
            while (!this.availableConns.isEmpty()) {
                NHttpClientConnection conn = this.availableConns.remove();
                if (conn.isOpen()) {
                    this.getLogger().debug("Re-using persistent connection");
                    request.setConnection(conn);
                    break;
                }
                this.allConns.remove(conn);
            }
            if (!request.isCompleted()) {
                this.pendingRequests.add(request);
                this.processConnectionRequests();
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(NHttpClientConnection conn) {
        if (conn == null) {
            return;
        }
        if (this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.allConns.contains(conn)) {
                if (conn.isOpen()) {
                    conn.setSocketTimeout(0);
                    AsyncConnectionRequest request = this.pendingRequests.poll();
                    if (request != null) {
                        this.getLogger().debug("Re-using persistent connection");
                        request.setConnection(conn);
                    } else {
                        this.availableConns.add(conn);
                    }
                } else {
                    this.allConns.remove(conn);
                    this.processConnectionRequests();
                }
            }
        }
    }

    private void processConnectionRequests() {
        AsyncConnectionRequest request;
        while (this.allConns.size() < this.maxConnections && (request = this.pendingRequests.poll()) != null) {
            InetSocketAddress address = new InetSocketAddress(this.target.getHostName(), this.target.getPort());
            ConnRequestCallback callback = new ConnRequestCallback(request);
            this.getLogger().info("Opening new CouchDB connection");
            this.ioreactor.connect((SocketAddress)address, null, (Object)request, (SessionRequestCallback)callback);
        }
    }

    static class ConnRequestCallback
    extends SpyObject
    implements SessionRequestCallback {
        private final AsyncConnectionRequest request;

        public ConnRequestCallback(AsyncConnectionRequest request) {
            this.request = request;
        }

        public void completed(SessionRequest request) {
            this.getLogger().info(request.getRemoteAddress() + " - Session request successful");
        }

        public void cancelled(SessionRequest request) {
            this.getLogger().info(request.getRemoteAddress() + " - Session request cancelled");
            this.request.cancel();
        }

        public void failed(SessionRequest request) {
            this.getLogger().error(request.getRemoteAddress() + " - Session request failed");
            IOException ex = request.getException();
            if (ex != null) {
                ex.printStackTrace();
            }
            this.request.cancel();
        }

        public void timeout(SessionRequest request) {
            this.getLogger().info(request.getRemoteAddress() + " - Session request timed out");
            this.request.cancel();
        }
    }

    static class ManagedClientHandler
    implements NHttpClientHandler {
        private final NHttpClientHandler handler;
        private final AsyncConnectionManager connMgr;

        public ManagedClientHandler(NHttpClientHandler handler, AsyncConnectionManager connMgr) {
            this.handler = handler;
            this.connMgr = connMgr;
        }

        public void connected(NHttpClientConnection conn, Object attachment) {
            AsyncConnectionRequest request = (AsyncConnectionRequest)attachment;
            this.handler.connected(conn, attachment);
            this.connMgr.addConnection(conn);
            request.setConnection(conn);
        }

        public void closed(NHttpClientConnection conn) {
            this.connMgr.removeConnection(conn);
            this.handler.closed(conn);
        }

        public void requestReady(NHttpClientConnection conn) {
            this.handler.requestReady(conn);
        }

        public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
            this.handler.outputReady(conn, encoder);
        }

        public void responseReceived(NHttpClientConnection conn) {
            this.handler.responseReceived(conn);
        }

        public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
            this.handler.inputReady(conn, decoder);
        }

        public void exception(NHttpClientConnection conn, HttpException ex) {
            this.handler.exception(conn, ex);
        }

        public void exception(NHttpClientConnection conn, IOException ex) {
            this.handler.exception(conn, ex);
        }

        public void timeout(NHttpClientConnection conn) {
            this.handler.timeout(conn);
        }
    }
}

