/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.couch.HttpOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFuture<T>
extends SpyObject
implements Future<T> {
    private final AtomicReference<T> objRef = new AtomicReference<Object>(null);
    private final CountDownLatch latch;
    private final long timeout;
    private OperationStatus status;
    private HttpOperation op;

    public HttpFuture(CountDownLatch latch, long timeout) {
        this.latch = latch;
        this.timeout = timeout;
    }

    @Override
    public boolean cancel(boolean c) {
        this.op.cancel();
        return true;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.status = new OperationStatus(false, "Timed out");
            throw new RuntimeException("Timed out waiting for operation", e);
        }
    }

    @Override
    public T get(long duration, TimeUnit units) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.latch.await(duration, units)) {
            if (this.op != null) {
                this.op.timeOut();
            }
            this.status = new OperationStatus(false, "Timed out");
            throw new TimeoutException("Timed out waiting for operation");
        }
        if (this.op != null && this.op.hasErrored()) {
            this.status = new OperationStatus(false, this.op.getException().getMessage());
            throw new ExecutionException(this.op.getException());
        }
        if (this.op.isCancelled()) {
            this.status = new OperationStatus(false, "Operation Cancelled");
            throw new ExecutionException(new RuntimeException("Cancelled"));
        }
        if (this.op != null && this.op.isTimedOut()) {
            this.status = new OperationStatus(false, "Timed out");
            throw new ExecutionException(new OperationTimeoutException("Operation timed out."));
        }
        return this.objRef.get();
    }

    public OperationStatus getStatus() {
        if (this.status == null) {
            try {
                this.get();
            }
            catch (InterruptedException e) {
                this.status = new OperationStatus(false, "Interrupted");
                Thread.currentThread().isInterrupted();
            }
            catch (ExecutionException e) {
                this.getLogger().warn((Object)"Error getting status of operation", e);
            }
        }
        return this.status;
    }

    public void set(T op, OperationStatus s) {
        this.objRef.set(op);
        this.status = s;
    }

    @Override
    public boolean isDone() {
        assert (this.op != null) : "No operation";
        return this.latch.getCount() == 0L || this.op.isCancelled() || this.op.hasErrored();
    }

    public void setOperation(HttpOperation to) {
        this.op = to;
    }

    @Override
    public boolean isCancelled() {
        assert (this.op != null) : "No operation";
        return this.op.isCancelled();
    }
}

