/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.couch.HttpOperation;
import net.spy.memcached.protocol.couch.RowWithDocs;
import net.spy.memcached.protocol.couch.ViewResponseWithDocs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewFuture
extends SpyObject
implements Future<ViewResponseWithDocs> {
    private final AtomicReference<ViewResponseWithDocs> viewRef = new AtomicReference<Object>(null);
    private final AtomicReference<BulkFuture<Map<String, Object>>> multigetRef = new AtomicReference<Object>(null);
    private OperationStatus status;
    private final CountDownLatch latch;
    private final long timeout;
    private HttpOperation op;

    public ViewFuture(CountDownLatch latch, long timeout) {
        this.latch = latch;
        this.timeout = timeout;
        this.status = null;
    }

    @Override
    public boolean cancel(boolean c) {
        this.op.cancel();
        return true;
    }

    @Override
    public ViewResponseWithDocs get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.status = new OperationStatus(false, "Timed out");
            throw new RuntimeException("Timed out waiting for operation", e);
        }
    }

    @Override
    public ViewResponseWithDocs get(long duration, TimeUnit units) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.latch.await(duration, units)) {
            if (this.op != null) {
                this.op.timeOut();
            }
            this.status = new OperationStatus(false, "Timed out");
            throw new TimeoutException("Timed out waiting for operation");
        }
        if (this.op != null && this.op.hasErrored()) {
            this.status = new OperationStatus(false, this.op.getException().getMessage());
            throw new ExecutionException(this.op.getException());
        }
        if (this.op.isCancelled()) {
            this.status = new OperationStatus(false, "Operation Cancelled");
            throw new ExecutionException(new RuntimeException("Cancelled"));
        }
        if (this.op != null && this.op.isTimedOut()) {
            this.status = new OperationStatus(false, "Timed out");
            throw new ExecutionException(new OperationTimeoutException("Operation timed out."));
        }
        Map docMap = (Map)this.multigetRef.get().get();
        ViewResponseWithDocs view = this.viewRef.get();
        LinkedList<RowWithDocs> rows = new LinkedList<RowWithDocs>();
        for (RowWithDocs r : view) {
            rows.add(new RowWithDocs(r.getId(), r.getKey(), r.getValue(), docMap.get(r.getId())));
        }
        return new ViewResponseWithDocs(rows, view.getErrors());
    }

    public OperationStatus getStatus() {
        if (this.status == null) {
            try {
                this.get();
            }
            catch (InterruptedException e) {
                this.status = new OperationStatus(false, "Interrupted");
                Thread.currentThread().isInterrupted();
            }
            catch (ExecutionException e) {
                this.getLogger().warn((Object)"Error getting status of operation", e);
            }
        }
        return this.status;
    }

    @Override
    public boolean isCancelled() {
        assert (this.op != null) : "No operation";
        return this.op.isCancelled();
    }

    @Override
    public boolean isDone() {
        assert (this.op != null) : "No operation";
        return this.latch.getCount() == 0L || this.op.isCancelled() || this.op.hasErrored();
    }

    public void setOperation(HttpOperation to) {
        this.op = to;
    }

    public void set(ViewResponseWithDocs viewResponse, BulkFuture<Map<String, Object>> op, OperationStatus s) {
        this.viewRef.set(viewResponse);
        this.multigetRef.set(op);
        this.status = s;
    }
}

