/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.couch;

import java.text.ParseException;
import java.util.LinkedList;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationException;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.couch.DocsOperation;
import net.spy.memcached.protocol.couch.HttpOperationImpl;
import net.spy.memcached.protocol.couch.RowError;
import net.spy.memcached.protocol.couch.RowWithDocs;
import net.spy.memcached.protocol.couch.ViewResponseWithDocs;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DocsOperationImpl
extends HttpOperationImpl
implements DocsOperation {
    public DocsOperationImpl(HttpRequest r, DocsOperation.DocsCallback cb) {
        super(r, cb);
    }

    public void handleResponse(HttpResponse response) {
        String json = this.getEntityString(response);
        int errorcode = response.getStatusLine().getStatusCode();
        try {
            OperationStatus status = this.parseViewForStatus(json, errorcode);
            ViewResponseWithDocs vr = this.parseDocsViewResult(json);
            ((DocsOperation.DocsCallback)this.callback).gotData(vr);
            this.callback.receivedStatus(status);
        }
        catch (ParseException e) {
            this.exception = new OperationException(OperationErrorType.GENERAL, "Error parsing JSON");
        }
        this.callback.complete();
    }

    private ViewResponseWithDocs parseDocsViewResult(String json) throws ParseException {
        LinkedList<RowWithDocs> rows = new LinkedList<RowWithDocs>();
        LinkedList<RowError> errors = new LinkedList<RowError>();
        if (json != null) {
            try {
                JSONObject elem;
                int i;
                JSONArray ids;
                JSONObject base = new JSONObject(json);
                if (base.has("rows")) {
                    ids = base.getJSONArray("rows");
                    for (i = 0; i < ids.length(); ++i) {
                        elem = ids.getJSONObject(i);
                        String id = elem.getString("id");
                        String key = elem.getString("key");
                        String value = elem.getString("value");
                        rows.add(new RowWithDocs(id, key, value, null));
                    }
                }
                if (base.has("errors")) {
                    ids = base.getJSONArray("errors");
                    for (i = 0; i < ids.length(); ++i) {
                        elem = ids.getJSONObject(i);
                        String from = elem.getString("from");
                        String reason = elem.getString("reason");
                        errors.add(new RowError(from, reason));
                    }
                }
            }
            catch (JSONException e) {
                throw new ParseException("Cannot read json: " + json, 0);
            }
        }
        return new ViewResponseWithDocs(rows, errors);
    }
}

