/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.couch;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.spy.memcached.protocol.couch.RowError;
import net.spy.memcached.protocol.couch.RowWithDocs;
import net.spy.memcached.protocol.couch.ViewResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewResponseWithDocs
implements ViewResponse<RowWithDocs>,
Map<String, Object> {
    final Map<String, Object> map = new HashMap<String, Object>();
    final Collection<RowWithDocs> rows;
    final Collection<RowError> errors;

    public ViewResponseWithDocs(Collection<RowWithDocs> r, Collection<RowError> e) {
        this.rows = r;
        this.errors = e;
        for (RowWithDocs row : this.rows) {
            this.map.put(row.getId(), row.getDoc());
        }
    }

    public void addError(RowError r) {
        this.errors.add(r);
    }

    @Override
    public Collection<RowError> getErrors() {
        return this.errors;
    }

    @Override
    public Iterator<RowWithDocs> iterator() {
        return this.rows.iterator();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (RowWithDocs r : this.rows) {
            s.append(r.getId() + " : " + r.getKey() + " : " + r.getValue() + " : " + r.getDoc() + "\n");
        }
        return s.toString();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear() is not supported");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<ViewResponseEntry<String, Object>> set = new HashSet<ViewResponseEntry<String, Object>>();
        for (RowWithDocs r : this.rows) {
            set.add(new ViewResponseEntry<String, Object>(r.getId(), this.map.get(r.getId())));
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        TreeSet<String> set = new TreeSet<String>();
        for (RowWithDocs r : this.rows) {
            set.add(r.getId());
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("put() is not supported");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException("putAll() is not supported");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("remove() is not supported");
    }

    @Override
    public int size() {
        assert (this.rows.size() == this.map.size());
        return this.rows.size();
    }

    @Override
    public Collection<Object> values() {
        LinkedList<Object> values = new LinkedList<Object>();
        for (RowWithDocs r : this.rows) {
            values.add(r.getDoc());
        }
        return values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ViewResponseEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public ViewResponseEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }
}

