/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.naming.ConfigurationException;
import net.spy.memcached.TapConnectionProvider;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.TapOperation;
import net.spy.memcached.tapmessage.RequestMessage;
import net.spy.memcached.tapmessage.ResponseMessage;
import net.spy.memcached.tapmessage.TapOpcode;

public class TapClient {
    protected BlockingQueue<Object> rqueue = new LinkedBlockingQueue<Object>();
    protected HashMap<Operation, TapConnectionProvider> omap = new HashMap();
    protected long messagesRead;
    private List<InetSocketAddress> addrs;

    public TapClient(InetSocketAddress ... ia) {
        this(Arrays.asList(ia));
    }

    public TapClient(List<InetSocketAddress> addrs) {
        this.addrs = addrs;
        this.messagesRead = 0L;
    }

    public ResponseMessage getNextMessage() {
        return this.getNextMessage(1L, TimeUnit.SECONDS);
    }

    public ResponseMessage getNextMessage(long time, TimeUnit timeunit) {
        try {
            Object m = this.rqueue.poll(time, timeunit);
            if (m == null) {
                return null;
            }
            if (m instanceof ResponseMessage) {
                return (ResponseMessage)m;
            }
            if (m instanceof TapAck) {
                TapAck ack = (TapAck)m;
                this.tapAck(ack.getConn(), ack.getOpcode(), ack.getOpaque(), ack.getCallback());
                return null;
            }
            throw new RuntimeException("Unexpected tap message type");
        }
        catch (InterruptedException e) {
            this.shutdown();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreMessages() {
        if (!this.rqueue.isEmpty()) {
            return true;
        }
        HashMap<Operation, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            for (Operation op : this.omap.keySet()) {
                if (!op.getState().equals((Object)OperationState.COMPLETE) && !op.isCancelled() && !op.hasErrored()) continue;
                this.omap.get(op).shutdown();
                this.omap.remove(op);
            }
            if (this.omap.size() > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation tapCustom(String id, RequestMessage message) throws ConfigurationException, IOException {
        final TapConnectionProvider conn = new TapConnectionProvider(this.addrs);
        final CountDownLatch latch = new CountDownLatch(1);
        TapOperation op = conn.getOpFactory().tapCustom(id, message, new TapOperation.Callback(){

            @Override
            public void receivedStatus(OperationStatus status) {
            }

            @Override
            public void gotData(ResponseMessage tapMessage) {
                TapClient.this.rqueue.add(tapMessage);
                ++TapClient.this.messagesRead;
            }

            @Override
            public void gotAck(TapOpcode opcode, int opaque) {
                TapClient.this.rqueue.add(new TapAck(conn, opcode, opaque, this));
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        HashMap<Operation, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(op, conn);
        }
        conn.addOp(op);
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation tapDump(String id) throws IOException, ConfigurationException {
        final TapConnectionProvider conn = new TapConnectionProvider(this.addrs);
        final CountDownLatch latch = new CountDownLatch(1);
        TapOperation op = conn.getOpFactory().tapDump(id, new TapOperation.Callback(){

            @Override
            public void receivedStatus(OperationStatus status) {
            }

            @Override
            public void gotData(ResponseMessage tapMessage) {
                TapClient.this.rqueue.add(tapMessage);
                ++TapClient.this.messagesRead;
            }

            @Override
            public void gotAck(TapOpcode opcode, int opaque) {
                TapClient.this.rqueue.add(new TapAck(conn, opcode, opaque, this));
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        HashMap<Operation, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(op, conn);
        }
        conn.addOp(op);
        return op;
    }

    private void tapAck(TapConnectionProvider conn, TapOpcode opcode, int opaque, OperationCallback cb) {
        TapOperation op = conn.getOpFactory().tapAck(opcode, opaque, cb);
        conn.addOp(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        HashMap<Operation, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            for (Map.Entry<Operation, TapConnectionProvider> me : this.omap.entrySet()) {
                me.getValue().shutdown();
            }
        }
    }

    public long getMessagesRead() {
        return this.messagesRead;
    }

    class TapAck {
        private TapConnectionProvider conn;
        private TapOpcode opcode;
        private int opaque;
        private OperationCallback cb;

        public TapAck(TapConnectionProvider conn, TapOpcode opcode, int opaque, OperationCallback cb) {
            this.conn = conn;
            this.opcode = opcode;
            this.opaque = opaque;
            this.cb = cb;
        }

        public TapConnectionProvider getConn() {
            return this.conn;
        }

        public TapOpcode getOpcode() {
            return this.opcode;
        }

        public int getOpaque() {
            return this.opaque;
        }

        public OperationCallback getCallback() {
            return this.cb;
        }
    }
}

