/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.tapmessage;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.spy.memcached.tapmessage.BaseMessage;
import net.spy.memcached.tapmessage.TapRequestFlag;

public class RequestMessage
extends BaseMessage {
    private boolean hasBackfill;
    private boolean hasVBucketList;
    private boolean hasFlags;
    private List<TapRequestFlag> flagList = new LinkedList<TapRequestFlag>();
    private short[] vblist = new short[0];
    private String name = UUID.randomUUID().toString();
    private long backfilldate = -1L;

    public RequestMessage() {
        this.totalbody += this.name.length();
        this.keylength = (short)this.name.length();
    }

    public void setFlags(TapRequestFlag f) {
        if (!this.flagList.contains((Object)f)) {
            if (!this.hasFlags) {
                this.hasFlags = true;
                this.extralength = (byte)(this.extralength + 4);
                this.totalbody += 4;
            }
            if (f.equals((Object)TapRequestFlag.BACKFILL)) {
                this.hasBackfill = true;
                this.totalbody += 8;
            }
            if (f.equals((Object)TapRequestFlag.LIST_VBUCKETS) || f.equals((Object)TapRequestFlag.TAKEOVER_VBUCKETS)) {
                this.hasVBucketList = true;
                this.totalbody += 2;
            }
            this.flagList.add(f);
        }
    }

    public List<TapRequestFlag> getFlags() {
        return this.flagList;
    }

    public void setBackfill(long date) {
        this.backfilldate = date;
    }

    public void setVbucketlist(short[] vbs) {
        int oldSize = (this.vblist.length + 1) * 2;
        int newSize = (vbs.length + 1) * 2;
        this.totalbody += newSize - oldSize;
        this.vblist = vbs;
    }

    public void setName(String n) {
        if (n.length() > 65535) {
            throw new IllegalArgumentException("Tap name too long");
        }
        this.totalbody += n.length() - this.name.length();
        this.keylength = (short)n.length();
        this.name = n;
    }

    @Override
    public ByteBuffer getBytes() {
        ByteBuffer bb = ByteBuffer.allocate(24 + this.getTotalbody());
        bb.put(this.magic.getMagic());
        bb.put(this.opcode.getOpcode());
        bb.putShort(this.keylength);
        bb.put(this.extralength);
        bb.put(this.datatype);
        bb.putShort(this.vbucket);
        bb.putInt(this.totalbody);
        bb.putInt(this.opaque);
        bb.putLong(this.cas);
        if (this.hasFlags) {
            int flag = 0;
            for (int i = 0; i < this.flagList.size(); ++i) {
                flag |= this.flagList.get(i).getFlag();
            }
            bb.putInt(flag);
        }
        bb.put(this.name.getBytes());
        if (this.hasBackfill) {
            bb.putLong(this.backfilldate);
        }
        if (this.hasVBucketList) {
            bb.putShort((short)this.vblist.length);
            for (int i = 0; i < this.vblist.length; ++i) {
                bb.putShort(this.vblist[i]);
            }
        }
        return (ByteBuffer)bb.flip();
    }
}

