/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.PreparedStatement;
import org.tranql.connector.jdbc.ConnectionWrapper;
import org.tranql.connector.jdbc.PreparedStatementWrapper;

public class PreparedStatementKey {
    private final int stmtFormat;
    static final int PREPARED_STMT_FORMAT_1 = 1;
    static final int PREPARED_STMT_FORMAT_2 = 2;
    static final int PREPARED_STMT_FORMAT_3 = 3;
    static final int PREPARED_STMT_FORMAT_4 = 4;
    static final int PREPARED_STMT_FORMAT_5 = 5;
    static final int PREPARED_STMT_FORMAT_6 = 6;
    String sql = null;
    protected int parm0 = 0;
    protected int parm1 = 0;
    protected int parm2 = 0;
    private static final int[] nullIntArray = new int[]{0};
    private static final String[] nullStringArray = new String[]{""};
    private int[] columnIndexes = nullIntArray;
    private String[] columnNames = nullStringArray;
    private int preparedStatementKeyHashcode = 0;
    PreparedStatement ps = null;
    ConnectionWrapper c = null;
    private boolean validStatement = false;
    PreparedStatementWrapper psw = null;

    public PreparedStatementKey(ConnectionWrapper c, String sql) {
        this.c = c;
        this.sql = sql;
        this.stmtFormat = 1;
        this.setHashCode();
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, int autoGeneratedKeys) {
        this.c = c;
        this.sql = sql;
        this.parm0 = autoGeneratedKeys;
        this.stmtFormat = 2;
        this.setHashCode();
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, int resultSetType, int resultSetConcurrency) {
        this.c = c;
        this.sql = sql;
        this.parm0 = resultSetType;
        this.parm1 = resultSetConcurrency;
        this.stmtFormat = 3;
        this.setHashCode();
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.c = c;
        this.sql = sql;
        this.parm0 = resultSetType;
        this.parm1 = resultSetConcurrency;
        this.parm2 = resultSetHoldability;
        this.stmtFormat = 4;
        this.setHashCode();
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, int[] columnIndexes) {
        this.c = c;
        this.sql = sql;
        this.columnIndexes = (int[])columnIndexes.clone();
        this.stmtFormat = 5;
        this.setHashCode();
    }

    public PreparedStatementKey(ConnectionWrapper c, String sql, String[] columnNames) {
        this.c = c;
        this.sql = sql;
        this.columnNames = (String[])columnNames.clone();
        this.stmtFormat = 6;
        this.setHashCode();
    }

    public int hashCode() {
        return this.preparedStatementKeyHashcode;
    }

    void setHashCode() {
        this.preparedStatementKeyHashcode = this.sql.hashCode() + this.parm0 * 10000 + this.parm1 * 1000 + this.parm2 * 100 + this.columnIndexes.hashCode() + this.columnNames.hashCode();
    }

    public boolean equals(Object o) {
        PreparedStatementKey psk = (PreparedStatementKey)o;
        if (psk.stmtFormat != this.stmtFormat) {
            return false;
        }
        if (!psk.sql.equals(this.sql)) {
            return false;
        }
        switch (this.stmtFormat) {
            case 1: {
                return true;
            }
            case 2: {
                return psk.parm0 == this.parm0;
            }
            case 3: {
                return psk.parm0 == this.parm0 && psk.parm1 == this.parm1;
            }
            case 4: {
                return psk.parm0 == this.parm0 && psk.parm1 == this.parm1 && psk.parm2 == this.parm2;
            }
            case 5: {
                if (psk.columnIndexes.length != this.columnIndexes.length) {
                    return false;
                }
                for (int y = 0; y < psk.columnIndexes.length; ++y) {
                    if (psk.columnIndexes[y] == this.columnIndexes[y]) continue;
                    return false;
                }
                return true;
            }
            case 6: {
                if (psk.columnNames.length != this.columnNames.length) {
                    return false;
                }
                for (int y = 0; y < psk.columnNames.length; ++y) {
                    if (psk.columnNames[y].equals(this.columnNames[y])) continue;
                    return false;
                }
                return true;
            }
        }
        throw new RuntimeException("Invalid Prepared Statment Format of " + this.stmtFormat + " detected in compare." + "Statement may be corrupted.\n" + "  Query = " + this.sql + "\n" + "  PreparedStatementWrapper Information:\n" + this.psw.toString());
    }

    public void setPreparedStatementWrapper(PreparedStatementWrapper psw) {
        this.psw = psw;
    }

    public PreparedStatementWrapper getPreparedStatementWrapper() {
        return this.psw;
    }
}

