/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.Bullet;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyLinkCollider;
import com.badlogic.gdx.physics.bullet.linearmath.LinearMath;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;

public class BulletMultiBodyJointParametersTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testDefaultBulletMultiBodyJointParameters() {
        BulletMultiBodyJointParameters jointParameters = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
        Vector3 intertia = new Vector3();
        Vector3 parentComToCurrentCom = new Vector3(0.0f, 0.1f, 0.0f);
        Vector3 currentPivotToCurrentCom = new Vector3(0.0f, -0.05f, 0.0f);
        Vector3 hingeJointAxis = new Vector3(1.0f, 0.0f, 0.0f);
        Vector3 parentComToCurrentPivot = new Vector3(parentComToCurrentCom.x - currentPivotToCurrentCom.x, parentComToCurrentCom.y - currentPivotToCurrentCom.y, parentComToCurrentCom.z - currentPivotToCurrentCom.z);
        Quaternion rotParentToThis = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        btMultiBody btMultiBody2 = new btMultiBody(1, 1.0f, intertia, false, true);
        btMultiBody2.setupRevolute(0, 0.0f, intertia, -1, rotParentToThis, hingeJointAxis, parentComToCurrentPivot, currentPivotToCurrentCom);
        btMultiBodyLinkCollider linkCollider = new btMultiBodyLinkCollider(btMultiBody2, 0);
        BulletMultiBodyJointParametersTest.assertJointParametersEquals(true, linkCollider.getFriction(), linkCollider.getRestitution(), linkCollider.getHitFraction(), linkCollider.getRollingFriction(), linkCollider.getSpinningFriction(), linkCollider.getContactProcessingThreshold(), jointParameters);
    }

    @Test
    public void testConstructor() {
        Random random = new Random(346742L);
        for (int i = 0; i < 1000; ++i) {
            boolean jointDisableParentCollision = random.nextBoolean();
            double jointFriction = random.nextDouble();
            double jointRestitution = random.nextDouble();
            double jointHitFration = random.nextDouble();
            double jointRollingFriction = random.nextDouble();
            double jointSpinningFriction = random.nextDouble();
            double jointContactProcessingThreshold = random.nextDouble();
            BulletMultiBodyJointParameters jointParameters = new BulletMultiBodyJointParameters(jointDisableParentCollision, jointFriction, jointRestitution, jointHitFration, jointRollingFriction, jointSpinningFriction, jointContactProcessingThreshold);
            BulletMultiBodyJointParametersTest.assertJointParametersEquals(jointDisableParentCollision, jointFriction, jointRestitution, jointHitFration, jointRollingFriction, jointSpinningFriction, jointContactProcessingThreshold, jointParameters);
        }
    }

    @Test
    public void testSetters() {
        Random random = new Random(125846L);
        for (int i = 0; i < 1000; ++i) {
            boolean jointDisableParentCollision = random.nextBoolean();
            double jointFriction = random.nextDouble();
            double jointRestitution = random.nextDouble();
            double jointHitFration = random.nextDouble();
            double jointRollingFriction = random.nextDouble();
            double jointSpinningFriction = random.nextDouble();
            double jointContactProcessingThreshold = random.nextDouble();
            BulletMultiBodyJointParameters jointParameters = new BulletMultiBodyJointParameters();
            jointParameters.setJointDisableParentCollision(jointDisableParentCollision);
            jointParameters.setJointFriction(jointFriction);
            jointParameters.setJointRestitution(jointRestitution);
            jointParameters.setJointHitFraction(jointHitFration);
            jointParameters.setJointRollingFriction(jointRollingFriction);
            jointParameters.setJointSpinningFriction(jointSpinningFriction);
            jointParameters.setJointContactProcessingThreshold(jointContactProcessingThreshold);
            BulletMultiBodyJointParametersTest.assertJointParametersEquals(jointDisableParentCollision, jointFriction, jointRestitution, jointHitFration, jointRollingFriction, jointSpinningFriction, jointContactProcessingThreshold, jointParameters);
        }
    }

    private static void assertJointParametersEquals(boolean jointDisableParentCollision, double jointFriction, double jointRestitution, double jointHitFration, double jointRollingFriction, double jointSpinningFriction, double jointContactProcessingThreshold, BulletMultiBodyJointParameters jointParameters) {
        Assertions.assertEquals((Object)jointDisableParentCollision, (Object)jointParameters.getJointDisableParentCollision());
        Assertions.assertEquals((float)((float)jointFriction), (float)((float)jointParameters.getJointFriction()));
        Assertions.assertEquals((float)((float)jointRestitution), (float)((float)jointParameters.getJointRestitution()));
        Assertions.assertEquals((float)((float)jointHitFration), (float)((float)jointParameters.getJointHitFraction()));
        Assertions.assertEquals((float)((float)jointRollingFriction), (float)((float)jointParameters.getJointRollingFriction()));
        Assertions.assertEquals((float)((float)jointSpinningFriction), (float)((float)jointParameters.getJointSpinningFriction()));
        Assertions.assertEquals((float)((float)jointContactProcessingThreshold), (float)((float)jointParameters.getJointContactProcessingThreshold()));
    }

    static {
        Bullet.init();
        LogTools.info((String)"Loaded Bullet version {}", (Object)LinearMath.btGetVersion());
    }
}

