/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;
import org.apache.velocity.tools.view.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultKey(value="link")
@ValidScope(value={"request"})
public class LinkTool
implements Cloneable {
    public static final String HTML_QUERY_DELIMITER = "&";
    public static final String XHTML_QUERY_DELIMITER = "&amp;";
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Log LOG;
    private String uri = null;
    private String anchor = null;
    private ArrayList queryData = null;
    private String queryDataDelim = "&amp;";
    private boolean selfAbsolute = false;
    private boolean selfParams = false;
    private boolean autoIgnoreParams = true;
    private HashSet<String> parametersToIgnore;

    public void setRequest(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request should not be null");
        }
        this.request = request;
    }

    public void setResponse(HttpServletResponse response) {
        if (response == null) {
            throw new NullPointerException("response should not be null");
        }
        this.response = response;
    }

    public void setServletContext(ServletContext application) {
        if (application == null) {
            throw new NullPointerException("servletContext should not be null");
        }
        this.application = application;
    }

    public void setLog(Log log) {
        if (log == null) {
            throw new NullPointerException("log should not be null");
        }
        this.LOG = log;
    }

    public void setXHTML(boolean useXhtml) {
        this.queryDataDelim = useXhtml ? XHTML_QUERY_DELIMITER : HTML_QUERY_DELIMITER;
    }

    public void setSelfAbsolute(boolean selfAbsolute) {
        this.selfAbsolute = selfAbsolute;
    }

    public void setSelfIncludeParameters(boolean selfParams) {
        this.selfParams = selfParams;
    }

    public void setAutoIgnoreParameters(boolean autoIgnore) {
        this.autoIgnoreParams = autoIgnore;
    }

    protected LinkTool copyWith(QueryPair pair) {
        LinkTool copy = this.duplicate();
        copy.queryData = copy.queryData != null ? (ArrayList)this.queryData.clone() : new ArrayList();
        copy.queryData.add(pair);
        if (copy.autoIgnoreParams) {
            if (copy.parametersToIgnore != null) {
                if (!copy.parametersToIgnore.contains(pair.getKey())) {
                    copy.parametersToIgnore = (HashSet)this.parametersToIgnore.clone();
                    copy.parametersToIgnore.add(pair.getKey());
                }
            } else {
                copy.parametersToIgnore = new HashSet();
                copy.parametersToIgnore.add(pair.getKey());
            }
        }
        return copy;
    }

    protected LinkTool copyWith(Map<Object, Object> newQueryData) {
        LinkTool copy = this.duplicate();
        copy.queryData = copy.queryData != null ? (ArrayList)this.queryData.clone() : new ArrayList();
        boolean clonedIgnore = false;
        for (Map.Entry<Object, Object> entry : newQueryData.entrySet()) {
            String key = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            copy.queryData.add(new QueryPair(key, value));
            if (!copy.autoIgnoreParams) continue;
            if (copy.parametersToIgnore != null) {
                if (copy.parametersToIgnore.contains(key)) continue;
                if (!clonedIgnore) {
                    copy.parametersToIgnore = (HashSet)this.parametersToIgnore.clone();
                    clonedIgnore = true;
                }
                copy.parametersToIgnore.add(key);
                continue;
            }
            copy.parametersToIgnore = new HashSet();
            copy.parametersToIgnore.add(key);
            clonedIgnore = true;
        }
        return copy;
    }

    protected LinkTool copyWith(String uri) {
        LinkTool copy = this.duplicate();
        copy.uri = uri;
        return copy;
    }

    protected LinkTool copyWithAnchor(String anchor) {
        LinkTool copy = this.duplicate();
        copy.anchor = anchor;
        return copy;
    }

    protected LinkTool copyWithIgnore(String parameterName) {
        LinkTool copy = this.duplicate();
        copy.parametersToIgnore = copy.parametersToIgnore == null ? new HashSet() : (HashSet)this.parametersToIgnore.clone();
        copy.parametersToIgnore.add(parameterName);
        return copy;
    }

    protected LinkTool duplicate() {
        try {
            return (LinkTool)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LinkTool copy;
            if (this.LOG != null) {
                this.LOG.warn((Object)("LinkTool : Could not properly clone " + this.getClass()), (Throwable)e);
            }
            try {
                copy = (LinkTool)this.getClass().newInstance();
            }
            catch (Exception ee) {
                copy = new LinkTool();
            }
            copy.application = this.application;
            copy.request = this.request;
            copy.response = this.response;
            copy.uri = this.uri;
            copy.anchor = this.anchor;
            copy.queryData = this.queryData;
            copy.queryDataDelim = this.queryDataDelim;
            copy.selfAbsolute = this.selfAbsolute;
            copy.selfParams = this.selfParams;
            copy.autoIgnoreParams = this.autoIgnoreParams;
            copy.parametersToIgnore = this.parametersToIgnore;
            return copy;
        }
    }

    public LinkTool setAnchor(String anchor) {
        return this.copyWithAnchor(anchor);
    }

    public LinkTool anchor(String anchor) {
        return this.setAnchor(anchor);
    }

    public String getAnchor() {
        return this.anchor;
    }

    public LinkTool setRelative(String uri) {
        String ctxPath = this.request.getContextPath();
        if (ctxPath.equals("/")) {
            ctxPath = "";
        }
        if (uri.startsWith("/")) {
            return this.copyWith(ctxPath + uri);
        }
        return this.copyWith(ctxPath + '/' + uri);
    }

    public LinkTool relative(String uri) {
        return this.setRelative(uri);
    }

    public LinkTool setAbsolute(String uri) {
        if (uri.startsWith("http")) {
            return this.setURI(uri);
        }
        String fullCtx = this.getContextURL();
        if (uri.startsWith("/")) {
            return this.copyWith(fullCtx + uri);
        }
        return this.copyWith(fullCtx + '/' + uri);
    }

    public LinkTool absolute(String uri) {
        return this.setAbsolute(uri);
    }

    public LinkTool setURI(String uri) {
        return this.copyWith(uri);
    }

    public LinkTool uri(String uri) {
        return this.setURI(uri);
    }

    public String getURI() {
        return this.uri;
    }

    public String getUri() {
        return this.getURI();
    }

    public LinkTool addQueryData(String key, Object value) {
        return this.copyWith(new QueryPair(key, value));
    }

    public LinkTool addQueryData(Map parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return this;
        }
        return this.copyWith(parameters);
    }

    public LinkTool param(Object key, Object value) {
        return this.addQueryData(String.valueOf(key), value);
    }

    public LinkTool params(Map parameters) {
        return this.addQueryData(parameters);
    }

    public String getQueryData() {
        if (this.queryData != null && !this.queryData.isEmpty()) {
            StringBuilder out = new StringBuilder();
            for (int i = 0; i < this.queryData.size(); ++i) {
                out.append(this.queryData.get(i));
                if (i + 1 >= this.queryData.size()) continue;
                out.append(this.queryDataDelim);
            }
            return out.toString();
        }
        return null;
    }

    public String getParams() {
        return this.getQueryData();
    }

    public LinkTool ignore(String paramName) {
        return this.addIgnore(paramName);
    }

    public LinkTool addIgnore(String parameterName) {
        return this.copyWithIgnore(parameterName);
    }

    public LinkTool selfParams() {
        return this.addAllParameters();
    }

    public LinkTool addAllParameters() {
        if (this.parametersToIgnore != null) {
            HashMap<Object, Object> params = new HashMap<Object, Object>(this.request.getParameterMap());
            for (String name : this.parametersToIgnore) {
                params.remove(name);
            }
            return this.copyWith(params);
        }
        return this.copyWith(this.request.getParameterMap());
    }

    public String getContextURL() {
        String scheme = this.request.getScheme();
        int port = this.request.getServerPort();
        StringBuilder out = new StringBuilder();
        out.append(this.request.getScheme());
        out.append("://");
        out.append(this.request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            out.append(':');
            out.append(port);
        }
        out.append(this.request.getContextPath());
        return out.toString();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getRequestPath() {
        return ServletUtils.getPath(this.request);
    }

    public String getBaseRef() {
        StringBuilder out = new StringBuilder();
        out.append(this.getContextURL());
        out.append(this.getRequestPath());
        return out.toString();
    }

    public LinkTool getSelf() {
        LinkTool dupe = this.selfAbsolute ? this.uri(this.getBaseRef()) : this.relative(this.getRequestPath());
        if (this.selfParams) {
            dupe = dupe.addAllParameters();
        }
        return dupe;
    }

    public String toString() {
        String str;
        String query;
        StringBuilder out = new StringBuilder();
        if (this.uri != null) {
            out.append(this.uri);
        }
        if ((query = this.getQueryData()) != null) {
            if (this.uri == null || this.uri.indexOf(63) < 0) {
                out.append('?');
            } else {
                out.append(this.queryDataDelim);
            }
            out.append(query);
        }
        if (this.anchor != null) {
            out.append('#');
            out.append(this.encodeURL(this.anchor));
        }
        if ((str = out.toString()).length() == 0) {
            return str;
        }
        return this.response.encodeURL(str);
    }

    public String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, this.response.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException uee) {
            if (this.LOG != null) {
                this.LOG.error((Object)("LinkTool : Response character encoding '" + this.response.getCharacterEncoding() + "' is unsupported"), (Throwable)uee);
            }
            return null;
        }
    }

    protected final class QueryPair {
        private final String key;
        private final Object value;

        public QueryPair(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            if (this.value == null) {
                out.append(LinkTool.this.encodeURL(this.key));
                out.append('=');
            } else if (this.value instanceof List) {
                this.appendAsArray(out, this.key, ((List)this.value).toArray());
            } else if (this.value instanceof Object[]) {
                this.appendAsArray(out, this.key, (Object[])this.value);
            } else {
                out.append(LinkTool.this.encodeURL(this.key));
                out.append('=');
                out.append(LinkTool.this.encodeURL(String.valueOf(this.value)));
            }
            return out.toString();
        }

        private void appendAsArray(StringBuilder out, String key, Object[] arr) {
            String encKey = LinkTool.this.encodeURL(key);
            for (int i = 0; i < arr.length; ++i) {
                out.append(encKey);
                out.append('=');
                if (arr[i] != null) {
                    out.append(LinkTool.this.encodeURL(String.valueOf(arr[i])));
                }
                if (i + 1 >= arr.length) continue;
                out.append(LinkTool.this.queryDataDelim);
            }
        }
    }
}

