/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.model;

import java.util.ArrayList;
import java.util.List;
import wicket.contrib.data.model.ISelectCountAndListAction;
import wicket.contrib.data.model.ModelException;
import wicket.contrib.data.model.UnimplementedList;
import wicket.markup.html.list.PageableListView;

public class PageableList
extends UnimplementedList {
    private static final int DEFAULT_PAGE_SIZE = 10;
    private int count;
    private ISelectCountAndListAction countAndListAction;
    private int currentPageStartIndex = -1;
    private boolean initialized = false;
    private List pageItems = new ArrayList();
    private int pageSize;

    public PageableList(int pageSize, ISelectCountAndListAction countAndListAction) {
        this.pageSize = pageSize;
        this.countAndListAction = countAndListAction;
    }

    public PageableList(ISelectCountAndListAction countAndListAction) {
        this(10, countAndListAction);
    }

    public PageableList(PageableListView table, ISelectCountAndListAction countAndListAction) {
        this(table.getRowsPerPage(), countAndListAction);
    }

    public final void clear() {
        this.pageItems.clear();
        this.currentPageStartIndex = -1;
        this.initialized = false;
    }

    public final Object get(int index) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("index is larger than number of query results");
        }
        int start = this.getCurrentPageStartIndex(index);
        if (start != this.currentPageStartIndex) {
            this.currentPageStartIndex = start;
            this.loadPage(this.currentPageStartIndex, this.getPageSize());
        }
        int windowIndex = this.getPageIndex(index);
        return this.pageItems.get(windowIndex);
    }

    public final ISelectCountAndListAction getCountAndListAction() {
        return this.countAndListAction;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final void setCountAndListAction(ISelectCountAndListAction countAndListAction) {
        this.countAndListAction = countAndListAction;
    }

    public final void setPageSize(int windowSize) {
        this.pageSize = windowSize;
    }

    public final int size() {
        if (!this.initialized) {
            this.count = this.getTotalSize();
            this.initialized = true;
        }
        return this.count;
    }

    public final List getPageItems() {
        return this.pageItems;
    }

    protected int getTotalSize() {
        Object result = this.countAndListAction.execute(this.getQueryObject());
        if (!(result instanceof Number)) {
            throw new ModelException("action result must be of type Number");
        }
        return ((Number)result).intValue();
    }

    protected Object getQueryObject() {
        return null;
    }

    protected List load(int startFromIndex, int numberOfElements) {
        return this.countAndListAction.execute(this.getQueryObject(), startFromIndex, numberOfElements);
    }

    private final void loadPage(int startFromIndex, int numberOfElements) {
        this.pageItems.clear();
        if (this.count > 0) {
            List loaded = this.load(startFromIndex, numberOfElements);
            this.pageItems.addAll(loaded);
        }
    }

    private final int getCurrentPageStartIndex(int index) {
        if (index < this.pageSize) {
            return 0;
        }
        return Math.abs(index / this.pageSize) * this.pageSize;
    }

    private int getPageIndex(int index) {
        return index % this.pageSize;
    }
}

