/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.model;

import java.io.Serializable;
import wicket.contrib.data.model.ISelectObjectAction;
import wicket.contrib.data.model.ModelException;
import wicket.model.IModel;
import wicket.model.Model;

public class PersistentObjectModel
implements IModel {
    private IModel idModel;
    private ISelectObjectAction selectObjectAction;
    private transient Object object;
    private transient boolean attached = false;

    public PersistentObjectModel(ISelectObjectAction selectObjectAction) {
        this((IModel)new Model(null), selectObjectAction);
    }

    public PersistentObjectModel(IModel idModel, ISelectObjectAction selectObjectAction) {
        this.idModel = idModel == null ? new Model(null) : idModel;
        this.selectObjectAction = selectObjectAction;
    }

    public PersistentObjectModel(Serializable id, ISelectObjectAction selectObjectAction) {
        this.idModel = new Model(id);
        this.selectObjectAction = selectObjectAction;
    }

    public final Object getObject() {
        this.attach();
        return this.object;
    }

    public final void setObject(Object object) {
        throw new ModelException("an object can only be set through its id");
    }

    public final boolean isAttached() {
        return this.attached;
    }

    public final void attach() {
        if (!this.attached) {
            this.onAttach();
            this.attached = true;
            Object id = this.getId();
            if (id != null && !(id instanceof Serializable)) {
                throw new ModelException("id must be serializable");
            }
            this.object = this.loadObject((Serializable)id);
        }
    }

    public final Object getId() {
        Object id = this.idModel.getObject();
        return id;
    }

    public final void setId(Serializable id) {
        this.idModel.setObject((Object)id);
        this.detach();
    }

    public Object loadObject(Serializable id) {
        return this.selectObjectAction.execute(id);
    }

    public final void detach() {
        if (this.attached) {
            this.onDetach();
            this.attached = false;
            this.object = null;
        }
    }

    protected void onAttach() {
    }

    protected void onDetach() {
    }

    public final IModel getIdModel() {
        return this.idModel;
    }

    public void setIdModel(IModel idModel) {
        this.idModel = idModel;
        this.detach();
    }

    protected final ISelectObjectAction getSelectObjectAction() {
        return this.selectObjectAction;
    }

    public final void setSelectObjectAction(ISelectObjectAction selectObjectAction) {
        this.selectObjectAction = selectObjectAction;
    }
}

