/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import wicket.contrib.data.model.IModelInputListener;
import wicket.contrib.data.model.ModelException;
import wicket.contrib.data.model.ModelInputEvent;
import wicket.contrib.data.model.PersistentObjectModel;
import wicket.model.IModel;
import wicket.model.PropertyModel;

public class PersistentObjectPropertyModel
extends PropertyModel {
    private List modelInputListeners;
    private final boolean checkWhetherInputIsSame;

    public PersistentObjectPropertyModel(PersistentObjectModel objectModel, String propertyName, boolean checkWhetherInputIsSame) {
        this(objectModel, propertyName, checkWhetherInputIsSame, null);
    }

    public PersistentObjectPropertyModel(PersistentObjectModel objectModel, String propertyName, boolean checkWhetherInputIsSame, IModelInputListener listener) {
        super((IModel)objectModel, propertyName);
        this.checkConstructorFields(objectModel, propertyName);
        this.checkWhetherInputIsSame = checkWhetherInputIsSame;
        this.addListener(listener);
    }

    public PersistentObjectPropertyModel(PersistentObjectModel objectModel, String propertyName, Class propertyType, boolean checkWhetherInputIsSame) {
        this(objectModel, propertyName, propertyType, checkWhetherInputIsSame, null);
    }

    public PersistentObjectPropertyModel(PersistentObjectModel objectModel, String propertyName, Class propertyType, boolean checkWhetherInputIsSame, IModelInputListener listener) {
        super((IModel)objectModel, propertyName, propertyType);
        this.checkConstructorFields(objectModel, propertyName);
        this.checkWhetherInputIsSame = checkWhetherInputIsSame;
        this.addListener(listener);
    }

    private void checkConstructorFields(PersistentObjectModel objectModel, String propertyName) {
        if (objectModel == null) {
            throw new ModelException("objectModel is not allowed to be null");
        }
        if (propertyName == null) {
            throw new ModelException("propertyName is not allowed to be null");
        }
    }

    public final void addListener(IModelInputListener listener) {
        if (listener == null) {
            return;
        }
        if (this.modelInputListeners == null) {
            this.modelInputListeners = new ArrayList(1);
        }
        this.modelInputListeners.add(listener);
    }

    public final boolean removeListener(IModelInputListener listener) {
        if (listener != null && this.modelInputListeners != null) {
            boolean removed = this.modelInputListeners.remove(listener);
            if (removed && this.modelInputListeners.isEmpty()) {
                this.modelInputListeners = null;
            }
            return removed;
        }
        return false;
    }

    public final void setObject(Object input) {
        boolean same = true;
        Object current = null;
        if (this.checkWhetherInputIsSame) {
            current = super.getObject();
        }
        super.setObject(input);
        if (this.checkWhetherInputIsSame) {
            if (current == null) {
                if (input != null) {
                    same = false;
                }
            } else if (input != null) {
                Object check = super.getObject();
                same = current.equals(check);
            } else {
                same = false;
            }
        }
        if (!same && this.modelInputListeners != null) {
            this.fireModelInput(input);
        }
    }

    protected void fireModelInput(Object input) {
        Iterator i = this.modelInputListeners.iterator();
        while (i.hasNext()) {
            IModelInputListener listener = (IModelInputListener)i.next();
            listener.modelInput(new ModelInputEvent((Object)this, input));
        }
    }
}

