/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.model.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import wicket.WicketRuntimeException;
import wicket.contrib.data.model.ISelectCountAndListAction;
import wicket.contrib.data.model.hibernate.IHibernateSessionDelegate;

public class HibernateCountAndListAction
implements ISelectCountAndListAction,
Serializable {
    private final IHibernateSessionDelegate sessionDelegate;
    private List orderColumns = new ArrayList();
    private final String queryName;
    private final String countQueryName;

    public HibernateCountAndListAction(String queryName, String countQueryName, IHibernateSessionDelegate sessionDelegate) {
        this.sessionDelegate = sessionDelegate;
        this.queryName = queryName;
        this.countQueryName = countQueryName;
    }

    public List execute(Object queryObject, int startFromRow, int numberOfRows) {
        return this.load(startFromRow, numberOfRows, queryObject);
    }

    public Object execute(Object queryObject) {
        return this.getCount(queryObject);
    }

    protected Integer getCount(Object queryObject) {
        try {
            Query query = this.getCountQuery();
            this.setParameters(query, queryObject);
            List countResult = query.list();
            return (Integer)countResult.get(0);
        }
        catch (HibernateException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    protected List load(int startFromRow, int numberOfRows, Object queryObject) {
        try {
            Query query = this.getQuery();
            this.setParameters(query, queryObject);
            query.setFirstResult(startFromRow);
            query.setMaxResults(numberOfRows);
            return query.list();
        }
        catch (HibernateException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    protected void setParameters(Query query, Object queryObject) throws HibernateException {
    }

    protected Query getQuery() {
        Query query;
        try {
            Session session = this.sessionDelegate.getSession();
            query = session.getNamedQuery(this.queryName);
            List orderColumns = this.getOrderColumns();
            if (!orderColumns.isEmpty()) {
                StringBuffer b = new StringBuffer(query.getQueryString());
                b.append(" ORDER BY ");
                Iterator i = orderColumns.iterator();
                while (i.hasNext()) {
                    Order order = (Order)i.next();
                    String direction = order.ascending ? "ASC" : "DESC";
                    b.append("upper(cd.").append(order.field).append(") ").append(direction);
                    if (!i.hasNext()) continue;
                    b.append(", ");
                }
                query = session.createQuery(b.toString());
            }
        }
        catch (HibernateException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        return query;
    }

    protected Query getCountQuery() {
        Query query;
        try {
            Session session = this.sessionDelegate.getSession();
            query = session.getNamedQuery(this.countQueryName);
        }
        catch (HibernateException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        return query;
    }

    public final String getQueryName() {
        return this.queryName;
    }

    public final String getCountQueryName() {
        return this.countQueryName;
    }

    public void addOrdering(String colName) {
        boolean ascending = true;
        Order order = new Order(colName);
        int i = this.orderColumns.indexOf(order);
        if (i != -1) {
            Order current = (Order)this.orderColumns.remove(i);
            ascending = !current.ascending;
        }
        order.ascending = ascending;
        this.orderColumns.add(0, order);
    }

    public void removeOrdering(String colName) {
        Order order = new Order(colName);
        int i = this.orderColumns.indexOf(order);
        if (i != -1) {
            Order current = (Order)this.orderColumns.remove(i);
        }
    }

    protected final List getOrderColumns() {
        return this.orderColumns;
    }

    protected final void setOrderColumns(List orderColumns) {
        this.orderColumns = orderColumns;
    }

    protected static class Order {
        String field;
        boolean ascending;

        public Order(String field) {
            this.field = field;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Order)) {
                return false;
            }
            Order that = (Order)obj;
            return this.field.equals(that.field);
        }
    }
}

