/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.model.hibernate;

import java.io.Serializable;
import wicket.contrib.data.model.ISelectObjectAction;
import wicket.contrib.data.model.ModelException;
import wicket.contrib.data.model.PersistentObjectModel;
import wicket.contrib.data.model.hibernate.HibernateSelectObjectAction;
import wicket.contrib.data.model.hibernate.IHibernateSessionDelegate;
import wicket.model.IModel;

public class HibernateObjectModel
extends PersistentObjectModel {
    private final Class objectClass;
    private final boolean createNewObjectWhenIdIsNull;
    private final NullIdHandler nullIdHandler;

    public HibernateObjectModel(IModel idModel, Class objectClass, IHibernateSessionDelegate sessionDelegate) {
        this(idModel, objectClass, sessionDelegate, true);
    }

    public HibernateObjectModel(Serializable id, Class objectClass, IHibernateSessionDelegate sessionDelegate) {
        this(id, objectClass, sessionDelegate, true);
    }

    public HibernateObjectModel(IModel idModel, Class objectClass, IHibernateSessionDelegate sessionDelegate, boolean createNewObjectWhenIdIsNull) {
        super(idModel, (ISelectObjectAction)new HibernateSelectObjectAction(objectClass, sessionDelegate));
        this.checkConstructorFields(objectClass, sessionDelegate);
        this.objectClass = objectClass;
        this.createNewObjectWhenIdIsNull = createNewObjectWhenIdIsNull;
        this.nullIdHandler = new DefaultNullIdHandler();
    }

    public HibernateObjectModel(Serializable id, Class objectClass, IHibernateSessionDelegate sessionDelegate, boolean createNewObjectWhenIdIsNull) {
        super(id, (ISelectObjectAction)new HibernateSelectObjectAction(objectClass, sessionDelegate));
        this.checkConstructorFields(objectClass, sessionDelegate);
        this.objectClass = objectClass;
        this.createNewObjectWhenIdIsNull = createNewObjectWhenIdIsNull;
        this.nullIdHandler = new DefaultNullIdHandler();
    }

    public HibernateObjectModel(IModel idModel, Class objectClass, IHibernateSessionDelegate sessionDelegate, NullIdHandler nullIdHandler) {
        super(idModel, (ISelectObjectAction)new HibernateSelectObjectAction(objectClass, sessionDelegate));
        this.checkConstructorFields(objectClass, sessionDelegate, nullIdHandler);
        this.objectClass = objectClass;
        this.createNewObjectWhenIdIsNull = false;
        this.nullIdHandler = nullIdHandler;
    }

    public HibernateObjectModel(Serializable id, Class objectClass, IHibernateSessionDelegate sessionDelegate, NullIdHandler nullIdHandler) {
        super(id, (ISelectObjectAction)new HibernateSelectObjectAction(objectClass, sessionDelegate));
        this.checkConstructorFields(objectClass, sessionDelegate, nullIdHandler);
        this.objectClass = objectClass;
        this.createNewObjectWhenIdIsNull = false;
        this.nullIdHandler = nullIdHandler;
    }

    private void checkConstructorFields(Class objectClass, IHibernateSessionDelegate sessionDelegate) {
        if (objectClass == null) {
            throw new ModelException("objectClass is not allowed to be null");
        }
        if (sessionDelegate == null) {
            throw new ModelException("sessionDelegate is not allowed to be null");
        }
    }

    private void checkConstructorFields(Class objectClass, IHibernateSessionDelegate sessionDelegate, NullIdHandler nullIdHandler) {
        this.checkConstructorFields(objectClass, sessionDelegate);
        if (nullIdHandler == null) {
            throw new ModelException("nullIdHandler is not allowed to be null");
        }
    }

    public Object loadObject(Serializable id) {
        if (id == null) {
            return this.nullIdHandler.getObjectForNullId();
        }
        return this.getSelectObjectAction().execute(id);
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public static interface NullIdHandler
    extends Serializable {
        public Object getObjectForNullId();
    }

    private final class DefaultNullIdHandler
    implements NullIdHandler {
        private transient Object dummy;

        private DefaultNullIdHandler() {
        }

        public Object getObjectForNullId() {
            if (HibernateObjectModel.this.createNewObjectWhenIdIsNull) {
                if (this.dummy == null) {
                    try {
                        this.dummy = HibernateObjectModel.this.objectClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new ModelException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ModelException(e);
                    }
                }
                return this.dummy;
            }
            return null;
        }
    }
}

