/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.model.hibernate;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import wicket.contrib.data.model.ISelectObjectAction;
import wicket.contrib.data.model.ModelException;
import wicket.contrib.data.model.hibernate.IHibernateSessionDelegate;

public final class HibernateSelectObjectAction
implements ISelectObjectAction {
    private final IHibernateSessionDelegate sessionDelegate;
    private final Class objectClass;

    public HibernateSelectObjectAction(Class objectClass, IHibernateSessionDelegate sessionDelegate) {
        this.sessionDelegate = sessionDelegate;
        this.objectClass = objectClass;
    }

    public Object execute(Object queryObject) {
        if (!(queryObject instanceof Serializable)) {
            throw new ModelException("queryObject must be the (serializable) id of the object");
        }
        return this.execute((Serializable)queryObject);
    }

    public Object execute(Serializable id) {
        try {
            return this.sessionDelegate.getSession().load(this.objectClass, id);
        }
        catch (HibernateException e) {
            throw new ModelException(e);
        }
    }
}

