/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.util.hibernate;

import java.io.IOException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import wicket.contrib.data.util.hibernate.ConfigException;
import wicket.contrib.data.util.hibernate.HibernateHelper;
import wicket.contrib.data.util.hibernate.HibernateHelperDelegate;
import wicket.contrib.data.util.hibernate.HibernateHelperThreadLocaleImpl;

public final class HibernateFilter
extends HibernateHelperThreadLocaleImpl
implements Filter {
    private Log log = LogFactory.getLog((Class)(class$wicket$contrib$data$util$hibernate$HibernateFilter == null ? (class$wicket$contrib$data$util$hibernate$HibernateFilter = HibernateFilter.class$("wicket.contrib.data.util.hibernate.HibernateFilter")) : class$wicket$contrib$data$util$hibernate$HibernateFilter));
    private boolean active = false;
    static /* synthetic */ Class class$wicket$contrib$data$util$hibernate$HibernateFilter;
    static /* synthetic */ Class class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl;

    public void init(FilterConfig filterConfig) throws ServletException {
        HibernateHelperDelegate delegate = HibernateHelper.getDelegate();
        if (delegate instanceof HibernateHelperThreadLocaleImpl) {
            this.active = true;
        } else {
            this.log.warn((Object)("This filter only functions when used with " + (class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl == null ? (class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl = HibernateFilter.class$("wicket.contrib.data.util.hibernate.HibernateHelperThreadLocaleImpl")) : class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl).getName() + " as the HibernateHelperDelegate for HibernateHelper"));
        }
        if (this.active) {
            String configStr = filterConfig.getInitParameter("config");
            if (configStr != null) {
                URL configUrl = (class$wicket$contrib$data$util$hibernate$HibernateFilter == null ? (class$wicket$contrib$data$util$hibernate$HibernateFilter = HibernateFilter.class$("wicket.contrib.data.util.hibernate.HibernateFilter")) : class$wicket$contrib$data$util$hibernate$HibernateFilter).getClassLoader().getResource(configStr);
                this.log.info((Object)("Using configfile " + configUrl.toString()));
                super.setConfigURL(configUrl);
            }
            try {
                super.init();
            }
            catch (ConfigException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Session sess2;
        Session session;
        if (this.active && (session = (Session)HibernateFilter.getHibernateHolder().get()) != null) {
            this.log.warn((Object)"A session is already associated with this thread!  Someone must have called getSession() outside of the context of a servlet request; closing session");
            try {
                session.close();
            }
            catch (HibernateException e) {
                this.log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            HibernateFilter.getHibernateHolder().set(null);
        }
        try {
            chain.doFilter(request, response);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Session sess2;
            Object var7_7 = null;
            if (this.active && (sess2 = (Session)HibernateFilter.getHibernateHolder().get()) != null) {
                HibernateFilter.getHibernateHolder().set(null);
                try {
                    sess2.close();
                }
                catch (HibernateException ex) {
                    this.log.error((Object)ex);
                }
            }
            throw throwable;
        }
        if (this.active && (sess2 = (Session)HibernateFilter.getHibernateHolder().get()) != null) {
            HibernateFilter.getHibernateHolder().set(null);
            try {
                sess2.close();
            }
            catch (HibernateException ex) {
                this.log.error((Object)ex);
            }
        }
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

