/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.util.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import wicket.contrib.data.util.hibernate.ConfigException;
import wicket.contrib.data.util.hibernate.HibernateHelperDelegate;
import wicket.contrib.data.util.hibernate.HibernateHelperThreadLocaleImpl;
import wicket.contrib.data.util.hibernate.URLHelper;

public class HibernateHelper {
    public static final int ACTION_CLOSE = 1;
    public static final int ACTION_DISCONNECT = 2;
    public static final String SYSTEM_PROPERTY_DELEGATE = "hibernatehelper.properties.delegate";
    public static final String SYSTEM_PROPERTY_HIBERNATE_CONFIG = "hibernatehelper.properties.hibernateConfig";
    public static final String PROPERTY_DELEGATE = "delegate";
    public static final String PROPERTY_HIBERNATE_CONFIG = "hibernateConfig";
    public static final String PROPERTIES_LOCATION = "/hibernatehelper.properties";
    private static Log log = LogFactory.getLog((Class)(class$wicket$contrib$data$util$hibernate$HibernateHelper == null ? (class$wicket$contrib$data$util$hibernate$HibernateHelper = HibernateHelper.class$("wicket.contrib.data.util.hibernate.HibernateHelper")) : class$wicket$contrib$data$util$hibernate$HibernateHelper));
    private static HibernateHelperDelegate delegate = null;
    static /* synthetic */ Class class$wicket$contrib$data$util$hibernate$HibernateHelper;
    static /* synthetic */ Class class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl;

    public static void init() throws ConfigException {
        delegate.init();
    }

    private static void initialize() {
        String filename = PROPERTIES_LOCATION;
        Properties properties = new Properties();
        InputStream is = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            is = loader.getResourceAsStream(filename);
        }
        if (loader == null || is == null) {
            is = (class$wicket$contrib$data$util$hibernate$HibernateHelper == null ? (class$wicket$contrib$data$util$hibernate$HibernateHelper = HibernateHelper.class$("wicket.contrib.data.util.hibernate.HibernateHelper")) : class$wicket$contrib$data$util$hibernate$HibernateHelper).getResourceAsStream(filename);
        }
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        HibernateHelper.initializeDelegate(properties);
        HibernateHelper.initializeHibernateConfig(properties);
    }

    private static void initializeDelegate(Properties properties) {
        String delegateImplClass = System.getProperty(SYSTEM_PROPERTY_DELEGATE);
        if (delegateImplClass == null) {
            delegateImplClass = properties.getProperty(PROPERTY_DELEGATE);
        }
        if (delegateImplClass != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = (class$wicket$contrib$data$util$hibernate$HibernateHelper == null ? (class$wicket$contrib$data$util$hibernate$HibernateHelper = HibernateHelper.class$("wicket.contrib.data.util.hibernate.HibernateHelper")) : class$wicket$contrib$data$util$hibernate$HibernateHelper).getClassLoader();
                }
                Class<?> clazz = loader.loadClass(delegateImplClass);
                delegate = (HibernateHelperDelegate)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (delegate == null) {
            log.info((Object)("fallback on default HibernateHelperDelegate implementation: " + (class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl == null ? (class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl = HibernateHelper.class$("wicket.contrib.data.util.hibernate.HibernateHelperThreadLocaleImpl")) : class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl).getName()));
            delegate = new HibernateHelperThreadLocaleImpl();
        }
    }

    private static void initializeHibernateConfig(Properties properties) {
        String hibernateConfig = System.getProperty(SYSTEM_PROPERTY_HIBERNATE_CONFIG);
        if (hibernateConfig == null) {
            hibernateConfig = properties.getProperty(PROPERTY_HIBERNATE_CONFIG);
        }
        if (hibernateConfig != null) {
            log.info((Object)("using Hibernate config from URL: " + hibernateConfig));
            try {
                URL config = URLHelper.convertToURL(hibernateConfig, class$wicket$contrib$data$util$hibernate$HibernateHelper == null ? (class$wicket$contrib$data$util$hibernate$HibernateHelper = HibernateHelper.class$("wicket.contrib.data.util.hibernate.HibernateHelper")) : class$wicket$contrib$data$util$hibernate$HibernateHelper);
                if (config != null) {
                    HibernateHelper.setConfigURL(config);
                } else {
                    log.error((Object)("unable to construct URL from " + hibernateConfig));
                }
            }
            catch (MalformedURLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Session getSession() throws HibernateException {
        return delegate.getSession();
    }

    public static void closeSession() throws HibernateException {
        delegate.closeSession();
    }

    public static void disconnectSession() throws HibernateException {
        delegate.disconnectSession();
    }

    public static void setSession(Session session, int actionForCurrentSession) {
        delegate.setSession(session, actionForCurrentSession);
    }

    public static SessionFactory getSessionFactory() {
        return delegate.getSessionFactory();
    }

    public static void setSessionFactory(SessionFactory theFactory) {
        delegate.setSessionFactory(theFactory);
    }

    public static URL getConfigURL() {
        return delegate.getConfigURL();
    }

    public static void setConfigURL(URL url) {
        log.info((Object)("use config from " + url));
        delegate.setConfigURL(url);
    }

    public static Configuration getConfiguration() {
        return delegate.getConfiguration();
    }

    public static String getInterceptorClass() {
        return delegate.getInterceptorClass();
    }

    public static void setInterceptorClass(String className) {
        delegate.setInterceptorClass(className);
    }

    public static boolean isSingleInterceptor() {
        return delegate.isSingleInterceptor();
    }

    public static void setSingleInterceptor(boolean b) {
        delegate.setSingleInterceptor(b);
    }

    public static HibernateHelperDelegate getDelegate() {
        return delegate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HibernateHelper.initialize();
    }
}

