/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.util.hibernate;

import java.net.URL;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import wicket.WicketRuntimeException;
import wicket.contrib.data.util.hibernate.ConfigException;
import wicket.contrib.data.util.hibernate.HibernateHelperDelegate;

public class HibernateHelperThreadLocaleImpl
implements HibernateHelperDelegate {
    private static Log log = LogFactory.getLog((Class)(class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl == null ? (class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl = HibernateHelperThreadLocaleImpl.class$("wicket.contrib.data.util.hibernate.HibernateHelperThreadLocaleImpl")) : class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl));
    private static FlushMode flushMode = FlushMode.COMMIT;
    private static boolean initialised = false;
    private static ThreadLocal hibernateHolder = new ThreadLocal();
    private static SessionFactory factory;
    private static URL configURL;
    private static Configuration configuration;
    private static Class interceptorClass;
    private static String interceptorClassName;
    private static boolean singleInterceptor;
    private static Interceptor staticInterceptor;
    static /* synthetic */ Class class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl;

    public void init() throws ConfigException {
        if (!initialised) {
            initialised = true;
            configuration = new Configuration();
            try {
                if (configURL != null) {
                    configuration.configure(configURL);
                } else {
                    configuration.configure();
                }
                factory = configuration.buildSessionFactory();
            }
            catch (HibernateException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ConfigException(e);
            }
        }
    }

    public Session getSession() throws HibernateException {
        Session sess = (Session)hibernateHolder.get();
        if (sess == null && factory != null) {
            if (interceptorClass != null) {
                Interceptor interceptor = null;
                try {
                    interceptor = this.getInterceptorInstance(interceptorClass);
                }
                catch (InstantiationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new HibernateException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new HibernateException((Throwable)e);
                }
                sess = factory.openSession(interceptor);
            } else {
                sess = factory.openSession();
            }
            hibernateHolder.set(sess);
            sess.setFlushMode(flushMode);
        }
        return sess;
    }

    public void closeSession() throws HibernateException {
        Session sess = (Session)hibernateHolder.get();
        if (sess != null) {
            hibernateHolder.set(null);
            try {
                sess.close();
            }
            catch (HibernateException ex) {
                log.error((Object)ex);
            }
        }
    }

    public void disconnectSession() throws HibernateException {
        Session sess = (Session)hibernateHolder.get();
        if (sess != null) {
            hibernateHolder.set(null);
            try {
                sess.disconnect();
            }
            catch (HibernateException ex) {
                log.error((Object)ex);
            }
        }
    }

    public void setSession(Session session, int actionForCurrentSession) {
        Session sess = (Session)hibernateHolder.get();
        if (sess != null) {
            if (actionForCurrentSession == 1) {
                try {
                    sess.close();
                }
                catch (HibernateException ex) {
                    log.error((Object)ex);
                }
            } else if (actionForCurrentSession == 2) {
                try {
                    sess.disconnect();
                }
                catch (HibernateException ex) {
                    log.error((Object)ex);
                }
            } else {
                throw new WicketRuntimeException("Invalid action " + actionForCurrentSession);
            }
        }
        hibernateHolder.set(session);
    }

    public SessionFactory getSessionFactory() {
        return factory;
    }

    public void setSessionFactory(SessionFactory theFactory) {
        factory = theFactory;
    }

    public URL getConfigURL() {
        return configURL;
    }

    public void setConfigURL(URL url) {
        configURL = url;
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    public void setFlushMode(FlushMode mode) {
        flushMode = mode;
    }

    public FlushMode getFlushMode() {
        return flushMode;
    }

    public String getInterceptorClass() {
        return interceptorClassName;
    }

    public void setInterceptorClass(String className) {
        interceptorClassName = null;
        interceptorClass = null;
        staticInterceptor = null;
        Interceptor instance = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl == null ? (class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl = HibernateHelperThreadLocaleImpl.class$("wicket.contrib.data.util.hibernate.HibernateHelperThreadLocaleImpl")) : class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl).getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(className);
            instance = this.getInterceptorInstance(clazz);
            log.info((Object)("set hibernate interceptor to " + className + "; singleInterceptor == " + singleInterceptor));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WicketRuntimeException((Throwable)e);
        }
        interceptorClassName = className;
        interceptorClass = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Interceptor getInterceptorInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        if (singleInterceptor) {
            Class clazz2 = class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl == null ? (class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl = HibernateHelperThreadLocaleImpl.class$("wicket.contrib.data.util.hibernate.HibernateHelperThreadLocaleImpl")) : class$wicket$contrib$data$util$hibernate$HibernateHelperThreadLocaleImpl;
            synchronized (clazz2) {
                if (staticInterceptor == null) {
                    staticInterceptor = (Interceptor)clazz.newInstance();
                }
                return staticInterceptor;
            }
        }
        return (Interceptor)clazz.newInstance();
    }

    public boolean isSingleInterceptor() {
        return singleInterceptor;
    }

    public void setSingleInterceptor(boolean b) {
        singleInterceptor = b;
    }

    public static ThreadLocal getHibernateHolder() {
        return hibernateHolder;
    }

    public static void setHibernateHolder(ThreadLocal hibernateHolder) {
        HibernateHelperThreadLocaleImpl.hibernateHolder = hibernateHolder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        configURL = null;
        configuration = null;
    }
}

