/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.data.util.hibernate;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;

public final class URLHelper {
    private URLHelper() {
    }

    public static URL convertToURL(String path, Class caller) throws MalformedURLException {
        return URLHelper.convertToURL(path, caller, null);
    }

    public static URL convertToURL(String pathToTranslate, Class caller, ServletContext servletContext) throws MalformedURLException {
        String path = pathToTranslate;
        URL url = null;
        url = path.startsWith("file:") || path.startsWith("http:") || path.startsWith("https:") || path.startsWith("ftp:") || path.startsWith("jar:") ? new URL(path) : (servletContext != null ? URLHelper.getServletContextURL(servletContext, path) : URLHelper.getClasspathURL(caller, path));
        return url;
    }

    private static URL getServletContextURL(ServletContext servletContext, String pathToTranslate) throws MalformedURLException {
        String path = pathToTranslate;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        URL url = servletContext.getResource(path);
        return url;
    }

    private static URL getClasspathURL(Class caller, String path) {
        URL url;
        ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
        if (clsLoader == null) {
            url = caller != null ? caller.getResource(path) : ClassLoader.getSystemResource(path);
        } else {
            url = clsLoader.getResource(path);
            if (url == null) {
                url = caller != null ? caller.getResource(path) : ClassLoader.getSystemResource(path);
            }
        }
        return url;
    }
}

