/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.markup.html.form.fvalidate;

import java.io.Serializable;
import wicket.contrib.markup.html.form.fvalidate.IValidationSpecResolver;
import wicket.contrib.markup.html.form.fvalidate.ValidationSpec;
import wicket.contrib.markup.html.form.fvalidate.ValidationSpecResolver;
import wicket.markup.ComponentTag;
import wicket.markup.html.form.FormComponent;
import wicket.model.IModel;

public class FValidateTextField
extends FormComponent {
    private IValidationSpecResolver validationSpecResolver = new ValidationSpecResolver();
    private String invalidInput;
    private String fValidateCode = "alt";
    private String fValidateMsg = "emsg";

    public FValidateTextField(String name, IModel model) {
        super(name, (Serializable)model);
    }

    public FValidateTextField(String name, IModel model, String expression) {
        super(name, (Serializable)model, expression);
    }

    public FValidateTextField(String name, Serializable object) {
        super(name, object);
    }

    public FValidateTextField(String name, Serializable object, String expression) {
        super(name, object, expression);
    }

    public final boolean supportsPersistence() {
        return true;
    }

    public final String getFValidateCode() {
        return this.fValidateCode;
    }

    public final void setFValidateCode(String validateCode) {
        this.fValidateCode = validateCode;
    }

    public final String getFValidateMsg() {
        return this.fValidateMsg;
    }

    public final void setFValidateMsg(String validateMsg) {
        this.fValidateMsg = validateMsg;
    }

    protected final IValidationSpecResolver getValidationSpecResolver() {
        return this.validationSpecResolver;
    }

    protected final void setValidationSpecResolver(IValidationSpecResolver validationSpecResolver) {
        this.validationSpecResolver = validationSpecResolver;
    }

    protected void onInvalid() {
        this.invalidInput = this.getInput();
    }

    protected final void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "text");
        super.onComponentTag(tag);
        if (this.invalidInput == null) {
            tag.put("value", this.getModelObjectAsString());
        } else {
            tag.put("value", this.invalidInput);
        }
        ValidationSpec spec = this.validationSpecResolver.getSpec(this);
        if (spec != null) {
            String msg;
            String code = spec.getCode();
            if (code != null) {
                tag.put(this.getFValidateCode(), code);
            }
            if ((msg = spec.getErrorMsg()) != null) {
                tag.put(this.getFValidateMsg(), msg);
            }
        }
    }

    protected void updateModel() {
        this.invalidInput = null;
        this.setModelObject(this.getInput());
    }
}

