/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.markup.html.form.fvalidate;

import java.util.Iterator;
import wicket.contrib.markup.html.form.fvalidate.IValidationSpecResolver;
import wicket.contrib.markup.html.form.fvalidate.ValidationSpec;
import wicket.markup.html.form.FormComponent;
import wicket.markup.html.form.validation.IValidator;
import wicket.markup.html.form.validation.IntegerValidator;
import wicket.markup.html.form.validation.LengthValidator;
import wicket.markup.html.form.validation.PatternValidator;
import wicket.markup.html.form.validation.RequiredValidator;
import wicket.markup.html.form.validation.TypeValidator;

public class ValidationSpecResolver
implements IValidationSpecResolver {
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public ValidationSpec getSpec(FormComponent formComponent) {
        ValidationSpec spec = this.internalGetSpec(formComponent);
        return spec;
    }

    protected final ValidationSpec internalGetSpec(FormComponent formComponent) {
        ValidationSpec spec = new ValidationSpec();
        boolean required = false;
        Iterator i = formComponent.getValidators().iterator();
        while (i.hasNext()) {
            IValidator validator = (IValidator)i.next();
            if (validator instanceof RequiredValidator) {
                required = true;
                continue;
            }
            if (spec.getCode() != null) continue;
            this.setSpecFields(spec, validator);
        }
        if (required && spec.getCode() == null) {
            spec.setCode("blank");
            spec.setErrorMsg("required");
        }
        return spec;
    }

    private final void setSpecFields(ValidationSpec spec, IValidator validator) {
        if (validator instanceof TypeValidator) {
            this.setSpecFieldsForType(spec, (TypeValidator)validator);
        } else if (validator instanceof LengthValidator) {
            LengthValidator val = (LengthValidator)validator;
            StringBuffer code = new StringBuffer("length|");
            StringBuffer msg = new StringBuffer();
            int min = val.isCheckMin() ? val.getMin() : 0;
            code.append(min);
            if (val.isCheckMax()) {
                int max = val.getMax();
                code.append("|").append(val.getMax());
                msg.append("length should be between ").append(min).append(" and ").append(max);
            } else {
                msg.append("length should be greater than ").append(min);
            }
            spec.setCode(code.toString());
            spec.setErrorMsg(msg.toString());
        } else if (validator instanceof IntegerValidator) {
            IntegerValidator val = (IntegerValidator)validator;
            StringBuffer code = new StringBuffer("number|0|");
            long min = val.getMin();
            long max = val.getMax();
            code.append(min).append("|").append(max);
            spec.setCode(code.toString());
            StringBuffer msg = new StringBuffer("number should be between ").append(min).append(" and ").append(max);
        } else if (validator instanceof PatternValidator) {
            // empty if block
        }
    }

    private void setSpecFieldsForType(ValidationSpec spec, TypeValidator validator) {
        Class type;
        if ((class$java$lang$Number == null ? (class$java$lang$Number = ValidationSpecResolver.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type = validator.getType())) {
            if ((class$java$lang$Double == null ? (class$java$lang$Double = ValidationSpecResolver.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type) || (class$java$lang$Float == null ? (class$java$lang$Float = ValidationSpecResolver.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type) || (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ValidationSpecResolver.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(type)) {
                spec.setCode("number|1");
                spec.setErrorMsg("not a valid decimal");
            } else {
                spec.setCode("number|0");
                spec.setErrorMsg("not a valid number");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

